<?php
/**
 * Team Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_team_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Team Section', 'bizzweb' ),
		'priority' => 70,
	)
);

// Team Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_team_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_team_section',
		array(
			'label'    => esc_html__( 'Enable Team Section', 'bizzweb' ),
			'section'  => 'bizzweb_team_section',
			'settings' => 'bizzweb_enable_team_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_team_section',
		array(
			'selector' => '#bizzweb_team_section .section-link',
			'settings' => 'bizzweb_enable_team_section',
		)
	);
}

// Team Section - Section Title.
$wp_customize->add_setting(
	'bizzweb_team_section_title',
	array(
		'default'           => __( 'Meet Our volunteers', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_team_section_title',
	array(
		'label'           => esc_html__( 'Section Title', 'bizzweb' ),
		'section'         => 'bizzweb_team_section',
		'settings'        => 'bizzweb_team_section_title',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_team_section_enabled',
	)
);

// Team Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_team_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_team_subtitle',
	array(
		'label'           => esc_html__( 'Team Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_team_section',
		'settings'        => 'bizzweb_team_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_team_section_enabled',
	)
);

// Team Section - Content Type.
$wp_customize->add_setting(
	'bizzweb_team_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_team_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'bizzweb' ),
		'section'         => 'bizzweb_team_section',
		'settings'        => 'bizzweb_team_content_type',
		'type'            => 'select',
		'active_callback' => 'bizzweb_is_team_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'bizzweb' ),
			'post' => esc_html__( 'Post', 'bizzweb' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Team Section - Select Post.
	$wp_customize->add_setting(
		'bizzweb_team_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_team_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_team_section',
			'settings'        => 'bizzweb_team_content_post_' . $i,
			'active_callback' => 'bizzweb_is_team_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_post_choices(),
		)
	);

	// Team Section - Select Page.
	$wp_customize->add_setting(
		'bizzweb_team_content_page_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_team_content_page_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Page %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_team_section',
			'settings'        => 'bizzweb_team_content_page_' . $i,
			'active_callback' => 'bizzweb_is_team_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_page_choices(),
		)
	);

	// Team Section - Designation.
	$wp_customize->add_setting(
		'bizzweb_team_designation_' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizzweb_team_designation_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Designation %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_team_section',
			'settings'        => 'bizzweb_team_designation_' . $i,
			'active_callback' => 'bizzweb_is_team_section_enabled',
		)
	);

	// Team Section - Social Links.
	$wp_customize->add_setting(
		'bizzweb_team_social_links_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control(
		new Bizzweb_Sortable_Repeater_Custom_Control(
			$wp_customize,
			'bizzweb_team_social_links_' . $i,
			array(
				'label'           => sprintf( esc_html__( 'Social Icons %d', 'bizzweb' ), $i ),
				'section'         => 'bizzweb_team_section',
				'button_labels'   => array(
					'add' => __( 'Add', 'bizzweb' ),
				),
				'active_callback' => 'bizzweb_is_team_section_enabled',
			)
		)
	);

	// Team Section - Horizontal Line.
	$wp_customize->add_setting(
		'bizzweb_team_horizontal_line_' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new Bizzweb_Customize_Horizontal_Line(
			$wp_customize,
			'bizzweb_team_horizontal_line_' . $i,
			array(
				'section'         => 'bizzweb_team_section',
				'settings'        => 'bizzweb_team_horizontal_line_' . $i,
				'active_callback' => 'bizzweb_is_team_section_enabled',
				'type'            => 'hr',
			)
		)
	);
}
