<?php
/**
 * Service Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_service_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Service Section', 'bizzweb' ),
		'priority' => 20,
	)
);

// Service Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_service_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_service_section',
		array(
			'label'    => esc_html__( 'Enable Service Section', 'bizzweb' ),
			'section'  => 'bizzweb_service_section',
			'settings' => 'bizzweb_enable_service_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_service_section',
		array(
			'selector' => '#bizzweb_service_section .section-link',
			'settings' => 'bizzweb_enable_service_section',
		)
	);
}

// Service Section - Section Title.
$wp_customize->add_setting(
	'bizzweb_service_title',
	array(
		'default'           => __( 'What We Do For You', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_service_title',
	array(
		'label'           => esc_html__( 'Section Title', 'bizzweb' ),
		'section'         => 'bizzweb_service_section',
		'settings'        => 'bizzweb_service_title',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_service_section_enabled',
	)
);

// Service Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_service_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_service_subtitle',
	array(
		'label'           => esc_html__( 'Service Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_service_section',
		'settings'        => 'bizzweb_service_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_service_section_enabled',
	)
);

// Service Section - Content Type.
$wp_customize->add_setting(
	'bizzweb_service_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_service_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'bizzweb' ),
		'section'         => 'bizzweb_service_section',
		'settings'        => 'bizzweb_service_content_type',
		'type'            => 'select',
		'active_callback' => 'bizzweb_is_service_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'bizzweb' ),
			'post' => esc_html__( 'Post', 'bizzweb' ),
		),
	)
);

for ( $i = 1; $i <= 6; $i++ ) {

	// Service Section - Services Icons.
	$wp_customize->add_setting(
		'bizzweb_service_icon_' . $i,
		array(
			'sanitize_callback' => 'bizzweb_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'bizzweb_service_icon_' . $i,
			array(
				'label'           => sprintf( esc_html__( 'Service Icon %d', 'bizzweb' ), $i ),
				'section'         => 'bizzweb_service_section',
				'settings'        => 'bizzweb_service_icon_' . $i,
				'active_callback' => 'bizzweb_is_service_section_enabled',
			)
		)
	);

	// Service Section - Select Post.
	$wp_customize->add_setting(
		'bizzweb_service_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_service_content_post_' . $i,
		array(
			'label'           => esc_html__( 'Select Post ', 'bizzweb' ) . $i,
			'section'         => 'bizzweb_service_section',
			'settings'        => 'bizzweb_service_content_post_' . $i,
			'active_callback' => 'bizzweb_is_service_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_post_choices(),
		)
	);

	// Service Section - Select Page.
	$wp_customize->add_setting(
		'bizzweb_service_content_page_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_service_content_page_' . $i,
		array(
			'label'           => esc_html__( 'Select Page ', 'bizzweb' ) . $i,
			'section'         => 'bizzweb_service_section',
			'settings'        => 'bizzweb_service_content_page_' . $i,
			'active_callback' => 'bizzweb_is_service_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_page_choices(),
		)
	);

}
