<?php
/**
 * Mission Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_mission_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Mission Section', 'bizzweb' ),
		'priority' => 50,
	)
);

// Mission Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_mission_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_mission_section',
		array(
			'label'    => esc_html__( 'Enable Mission Section', 'bizzweb' ),
			'section'  => 'bizzweb_mission_section',
			'settings' => 'bizzweb_enable_mission_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_mission_section',
		array(
			'selector' => '#bizzweb_mission_section .section-link',
			'settings' => 'bizzweb_enable_mission_section',
		)
	);
}

// Mission Section - Content Type.
$wp_customize->add_setting(
	'bizzweb_mission_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_mission_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'bizzweb' ),
		'section'         => 'bizzweb_mission_section',
		'settings'        => 'bizzweb_mission_content_type',
		'type'            => 'select',
		'active_callback' => 'bizzweb_is_mission_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'bizzweb' ),
			'post' => esc_html__( 'Post', 'bizzweb' ),
		),
	)
);

// Service Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_mission_subtitle',
	array(
		'default'           => __( 'Our Mission', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_mission_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_mission_section',
		'settings'        => 'bizzweb_mission_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_mission_section_enabled',
	)
);

// Mission Section - Content Type Post.
$wp_customize->add_setting(
	'bizzweb_mission_content_post',
	array(
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'bizzweb_mission_content_post',
	array(
		'section'         => 'bizzweb_mission_section',
		'settings'        => 'bizzweb_mission_content_post',
		'label'           => esc_html__( 'Select Post', 'bizzweb' ),
		'type'            => 'select',
		'choices'         => bizzweb_get_post_choices(),
		'active_callback' => 'bizzweb_is_mission_section_and_content_type_post_enabled',
	)
);

// Mission Section - Content Type Page.
$wp_customize->add_setting(
	'bizzweb_mission_content_page',
	array(
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'bizzweb_mission_content_page',
	array(
		'label'           => esc_html__( 'Select Page', 'bizzweb' ),
		'section'         => 'bizzweb_mission_section',
		'settings'        => 'bizzweb_mission_content_page',
		'type'            => 'select',
		'choices'         => bizzweb_get_page_choices(),
		'active_callback' => 'bizzweb_is_mission_section_and_content_type_page_enabled',
	)
);

// Mission Section - Mission Lists.
$wp_customize->add_setting(
	'bizzweb_mission_list',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Bizzweb_Multi_Input_Custom_control(
		$wp_customize,
		'bizzweb_mission_list',
		array(
			'label'           => esc_html__( 'Mission List', 'bizzweb' ),
			'section'         => 'bizzweb_mission_section',
			'active_callback' => 'bizzweb_is_mission_section_enabled',
		)
	)
);

