<?php
/**
 * Latest News Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_latest_news_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Latest News Section', 'bizzweb' ),
		'priority' => 80,
	)
);

// Latest News Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_latest_news_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_latest_news_section',
		array(
			'label'    => esc_html__( 'Enable Latest News Section', 'bizzweb' ),
			'section'  => 'bizzweb_latest_news_section',
			'settings' => 'bizzweb_enable_latest_news_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_latest_news_section',
		array(
			'selector' => '#bizzweb_latest_news_section .section-link',
			'settings' => 'bizzweb_enable_latest_news_section',
		)
	);
}

// Latest News Section - Section Title.
$wp_customize->add_setting(
	'bizzweb_latest_news_section_title',
	array(
		'default'           => __( 'Latest From News', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_latest_news_section_title',
	array(
		'label'           => esc_html__( 'Section Title', 'bizzweb' ),
		'section'         => 'bizzweb_latest_news_section',
		'settings'        => 'bizzweb_latest_news_section_title',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_latest_news_section_enabled',
	)
);

// Latest News Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_latest_news_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_latest_news_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_latest_news_section',
		'settings'        => 'bizzweb_latest_news_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_latest_news_section_enabled',
	)
);

// Latest News Section - Number of Posts.
$wp_customize->add_setting(
	'bizzweb_latest_news_count',
	array(
		'default'           => 3,
		'sanitize_callback' => 'bizzweb_sanitize_number_range',
		'validate_callback' => 'bizzweb_validate_latest_news_count',
	)
);

$wp_customize->add_control(
	'bizzweb_latest_news_count',
	array(
		'label'           => esc_html__( 'Number of Items to Show', 'bizzweb' ),
		'description'     => esc_html__( 'Min 1 & Max 6. Please input the valid number and save. Then refresh the page to see the change.', 'bizzweb' ),
		'section'         => 'bizzweb_latest_news_section',
		'settings'        => 'bizzweb_latest_news_count',
		'type'            => 'number',
		'input_attrs'     => array(
			'min' => 1,
			'max' => 6,
		),
		'active_callback' => 'bizzweb_is_latest_news_section_enabled',
	)
);

// Latest News Section - Content Type.
$wp_customize->add_setting(
	'bizzweb_latest_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_latest_news_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'bizzweb' ),
		'section'         => 'bizzweb_latest_news_section',
		'settings'        => 'bizzweb_latest_news_content_type',
		'type'            => 'select',
		'active_callback' => 'bizzweb_is_latest_news_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'bizzweb' ),
			'category' => esc_html__( 'Category', 'bizzweb' ),
		),
	)
);

// Latest News Section - Select Latest News Category.
$wp_customize->add_setting(
	'bizzweb_latest_news_content_category',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_latest_news_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'bizzweb' ),
		'section'         => 'bizzweb_latest_news_section',
		'settings'        => 'bizzweb_latest_news_content_category',
		'active_callback' => 'bizzweb_is_latest_news_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => bizzweb_get_post_cat_choices(),
	)
);

// List out selected number of fields.
$latest_news_count = get_theme_mod( 'bizzweb_latest_news_count', 3 );

for ( $i = 1; $i <= $latest_news_count; $i++ ) {
	// Latest News Section - Select Post.
	$wp_customize->add_setting(
		'bizzweb_latest_news_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_latest_news_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_latest_news_section',
			'settings'        => 'bizzweb_latest_news_content_post_' . $i,
			'active_callback' => 'bizzweb_is_latest_news_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_post_choices(),
		)
	);

}
