<?php
/**
 * Counter Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_counter_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Counter Section', 'bizzweb' ),
		'priority' => 40,
	)
);

// Counter Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_counter_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_counter_section',
		array(
			'label'    => esc_html__( 'Enable Counter Section', 'bizzweb' ),
			'section'  => 'bizzweb_counter_section',
			'settings' => 'bizzweb_enable_counter_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_counter_section',
		array(
			'selector' => '#bizzweb_counter_section .section-link',
			'settings' => 'bizzweb_enable_counter_section',
		)
	);
}

// Counter Section - Background Image.
$wp_customize->add_setting(
	'bizzweb_counter_background_image',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'bizzweb_counter_background_image',
		array(
			'label'           => esc_html__( 'Background Image', 'bizzweb' ),
			'section'         => 'bizzweb_counter_section',
			'settings'        => 'bizzweb_counter_background_image',
			'active_callback' => 'bizzweb_is_counter_section_enabled',
		)
	)
);


// Counter Section - Section Title.
$wp_customize->add_setting(
	'bizzweb_counter_title',
	array(
		'default'           => __( 'Counter Section', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_counter_title',
	array(
		'label'           => esc_html__( 'Counter Title', 'bizzweb' ),
		'section'         => 'bizzweb_counter_section',
		'settings'        => 'bizzweb_counter_title',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_counter_section_enabled',
	)
);

// Counter Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_counter_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_counter_subtitle',
	array(
		'label'           => esc_html__( 'Counter Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_counter_section',
		'settings'        => 'bizzweb_counter_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_counter_section_enabled',
	)
);

for ( $i = 1; $i <= 4; $i++ ) {

	// Counter Section - Counter Icon.
	$wp_customize->add_setting(
		'bizzweb_counter_icon_' . $i,
		array(
			'sanitize_callback' => 'bizzweb_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'bizzweb_counter_icon_' . $i,
			array(
				'label'           => sprintf( esc_html__( 'Icon %d', 'bizzweb' ), $i ),
				'section'         => 'bizzweb_counter_section',
				'settings'        => 'bizzweb_counter_icon_' . $i,
				'active_callback' => 'bizzweb_is_counter_section_enabled',
			)
		)
	);

	// Counter Section - Counter Value.
	$wp_customize->add_setting(
		'bizzweb_counter_value_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_counter_value_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Value %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_counter_section',
			'settings'        => 'bizzweb_counter_value_' . $i,
			'type'            => 'number',
			'input_attrs'     => array( 'min' => 1 ),
			'active_callback' => 'bizzweb_is_counter_section_enabled',
		)
	);

	// Counter Section - Counter Suffix.
	$wp_customize->add_setting(
		'bizzweb_counter_value_suffix_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizzweb_counter_value_suffix_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Value Suffix %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_counter_section',
			'settings'        => 'bizzweb_counter_value_suffix_' . $i,
			'type'            => 'text',
			'active_callback' => 'bizzweb_is_counter_section_enabled',
		)
	);

	// Counter Section - Counter Label.
	$wp_customize->add_setting(
		'bizzweb_counter_label_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizzweb_counter_label_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Label %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_counter_section',
			'settings'        => 'bizzweb_counter_label_' . $i,
			'type'            => 'text',
			'active_callback' => 'bizzweb_is_counter_section_enabled',
		)
	);

	// Counter Section - Horizontal Line.
	$wp_customize->add_setting(
		'bizzweb_counter_horizontal_line_' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new Bizzweb_Customize_Horizontal_Line(
			$wp_customize,
			'bizzweb_counter_horizontal_line_' . $i,
			array(
				'section'         => 'bizzweb_counter_section',
				'settings'        => 'bizzweb_counter_horizontal_line_' . $i,
				'active_callback' => 'bizzweb_is_counter_section_enabled',
				'type'            => 'hr',
			)
		)
	);

}
