<?php
/**
 * Banner Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_banner_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'bizzweb' ),
		'priority' => 10,
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'bizzweb' ),
			'section'  => 'bizzweb_banner_section',
			'settings' => 'bizzweb_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_banner_section',
		array(
			'selector' => '#bizzweb_banner_section .section-link',
			'settings' => 'bizzweb_enable_banner_section',
		)
	);
}

// Banner Section - Banner Slider Content Type.
$wp_customize->add_setting(
	'bizzweb_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'bizzweb' ),
		'section'         => 'bizzweb_banner_section',
		'settings'        => 'bizzweb_banner_slider_content_type',
		'type'            => 'select',
		'active_callback' => 'bizzweb_is_banner_slider_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'bizzweb' ),
			'post' => esc_html__( 'Post', 'bizzweb' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {

	// Banner Section - Select Banner Post.
	$wp_customize->add_setting(
		'bizzweb_banner_slider_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_banner_slider_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_banner_section',
			'settings'        => 'bizzweb_banner_slider_content_post_' . $i,
			'active_callback' => 'bizzweb_is_banner_slider_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_post_choices(),
		)
	);

	// Banner Section - Select Banner Page.
	$wp_customize->add_setting(
		'bizzweb_banner_slider_content_page_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'bizzweb_banner_slider_content_page_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Page %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_banner_section',
			'settings'        => 'bizzweb_banner_slider_content_page_' . $i,
			'active_callback' => 'bizzweb_is_banner_slider_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => bizzweb_get_page_choices(),
		)
	);

	// Banner Section - Button Label.
	$wp_customize->add_setting(
		'bizzweb_banner_button_label_' . $i,
		array(
			'default'           => __( 'Get Started', 'bizzweb' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizzweb_banner_button_label_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Button Label %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_banner_section',
			'settings'        => 'bizzweb_banner_button_label_' . $i,
			'type'            => 'text',
			'active_callback' => 'bizzweb_is_banner_slider_section_enabled',
		)
	);

	// Banner Section - Button Link.
	$wp_customize->add_setting(
		'bizzweb_banner_button_link_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'bizzweb_banner_button_link_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Button Link %d', 'bizzweb' ), $i ),
			'section'         => 'bizzweb_banner_section',
			'settings'        => 'bizzweb_banner_button_link_' . $i,
			'type'            => 'url',
			'active_callback' => 'bizzweb_is_banner_slider_section_enabled',
		)
	);

	// Banner Section - Horizontal Line.
	$wp_customize->add_setting(
		'bizzweb_banner_horizontal_line_' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new Bizzweb_Customize_Horizontal_Line(
			$wp_customize,
			'bizzweb_banner_horizontal_line_' . $i,
			array(
				'section'         => 'bizzweb_banner_section',
				'settings'        => 'bizzweb_banner_horizontal_line_' . $i,
				'active_callback' => 'bizzweb_is_banner_slider_section_enabled',
				'type'            => 'hr',
			)
		)
	);

}
