<?php
/**
 * About Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_about_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'About Us Section', 'bizzweb' ),
		'priority' => 30,
	)
);

// About Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_about_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_about_section',
		array(
			'label'    => esc_html__( 'Enable About Section', 'bizzweb' ),
			'section'  => 'bizzweb_about_section',
			'settings' => 'bizzweb_enable_about_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_about_section',
		array(
			'selector' => '#bizzweb_about_section .section-link',
			'settings' => 'bizzweb_enable_about_section',
		)
	);
}

// About Section - Content Type.
$wp_customize->add_setting(
	'bizzweb_about_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_about_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'bizzweb' ),
		'section'         => 'bizzweb_about_section',
		'settings'        => 'bizzweb_about_content_type',
		'type'            => 'select',
		'active_callback' => 'bizzweb_is_about_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'bizzweb' ),
			'post' => esc_html__( 'Post', 'bizzweb' ),
		),
	)
);

// About Section - Content Type Post.
$wp_customize->add_setting(
	'bizzweb_about_content_post',
	array(
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'bizzweb_about_content_post',
	array(
		'section'         => 'bizzweb_about_section',
		'settings'        => 'bizzweb_about_content_post',
		'label'           => esc_html__( 'Select Post', 'bizzweb' ),
		'type'            => 'select',
		'choices'         => bizzweb_get_post_choices(),
		'active_callback' => 'bizzweb_is_about_section_and_content_type_post_enabled',
	)
);

// About Section - Content Type Page.
$wp_customize->add_setting(
	'bizzweb_about_content_page',
	array(
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'bizzweb_about_content_page',
	array(
		'label'           => esc_html__( 'Select Page', 'bizzweb' ),
		'section'         => 'bizzweb_about_section',
		'settings'        => 'bizzweb_about_content_page',
		'type'            => 'select',
		'choices'         => bizzweb_get_page_choices(),
		'active_callback' => 'bizzweb_is_about_section_and_content_type_page_enabled',
	)
);

// About Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_about_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_about_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_about_section',
		'settings'        => 'bizzweb_about_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_about_section_enabled',
	)
);

// About Section - Button Label.
$wp_customize->add_setting(
	'bizzweb_about_button_label',
	array(
		'default'           => __( 'Read More', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_about_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'bizzweb' ),
		'section'         => 'bizzweb_about_section',
		'settings'        => 'bizzweb_about_button_label',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_about_section_enabled',
	)
);
