<?php
/**
 * bizzweb Theme Customizer
 *
 * @package Bizzweb
 */

// Sanitize callback.
require get_template_directory() . '/inc/customizer/sanitize-callback.php';

// Active Callback.
require get_template_directory() . '/inc/customizer/active-callback.php';

// Validation.
require get_template_directory() . '/inc/customizer/validation.php';

// Custom Controls.
require get_template_directory() . '/inc/customizer/custom-controls/custom-controls.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function bizzweb_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'bizzweb_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'bizzweb_customize_partial_blogdescription',
			)
		);
	}

	// Homepage Settings - Enable Homepage Content.
	$wp_customize->add_setting(
		'bizzweb_enable_frontpage_content',
		array(
			'default'           => false,
			'sanitize_callback' => 'bizzweb_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizzweb_enable_frontpage_content',
		array(
			'label'           => esc_html__( 'Enable Homepage Content', 'bizzweb' ),
			'description'     => esc_html__( 'Check to enable content on static homepage.', 'bizzweb' ),
			'section'         => 'static_front_page',
			'type'            => 'checkbox',
			'active_callback' => 'bizzweb_is_static_homepage_enabled',
		)
	);

	// Upsell Section.
	$wp_customize->add_section(
		new Bizzweb_Upsell_Section(
			$wp_customize,
			'upsell_section',
			array(
				'title'            => __( 'Bizzweb Pro', 'bizzweb' ),
				'button_text'      => __( 'Buy Pro', 'bizzweb' ),
				'url'              => 'https://ascendoor.com/themes/bizzweb-pro/',
				'background_color' => '#4D5DB4',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

	// Theme Options.
	require get_template_directory() . '/inc/customizer/theme-options.php';

	// Front Page Options.
	require get_template_directory() . '/inc/customizer/front-page-options.php';

}
add_action( 'customize_register', 'bizzweb_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function bizzweb_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function bizzweb_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function bizzweb_customize_preview_js() {

	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'bizzweb-customizer', get_template_directory_uri() . '/assets/js/customizer' . $min . '.js', array( 'customize-preview' ), BIZZWEB_VERSION, true );
}
add_action( 'customize_preview_init', 'bizzweb_customize_preview_js' );

/**
 * Enqueue script for custom customize control.
 */
function bizzweb_custom_control_scripts() {

	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'bizzweb-custom-controls-css', get_template_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array(), '1.0', 'all' );
	wp_enqueue_script( 'bizzweb-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'jquery', 'jquery-ui-core' ), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'bizzweb_custom_control_scripts' );
