<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bizzweb
 */

?>
<!doctype html>
	<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">

		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<?php wp_body_open(); ?>
		<div id="page" class="site">

			<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'bizzweb' ); ?></a>

			<div id="loader" class="loader-1">
				<div class="loader-container">
					<div id="preloader"></div>
				</div>
			</div><!-- #loader -->

			<header id="masthead" class="site-header">

				<?php if ( get_theme_mod( 'bizzweb_enable_topbar', false ) === true ) { ?>
					<div class="bizzweb-top-header">
						<div class="section-wrapper">
							<div class="bizzweb-top-header-wrapper">
								<div class="bizzweb-top-header-left">
									<div class="top-left-header-container">
										<div class="bizzweb-brand-contact-wrapper">
											<div class="bizzweb-brand-contact">
												<?php
												$contact_label = get_theme_mod( 'bizzweb_topbar_contact_label', '' );
												$contact_no    = get_theme_mod( 'bizzweb_contact_number', '' );
												$email_label   = get_theme_mod( 'bizzweb_topbar_email_label', '' );
												$email_address = get_theme_mod( 'bizzweb_email_address', '' );
												if ( ! empty( $contact_label || $contact_no ) ) {
													?>
													<div class="brand-phone">
														<div class="brand-contact">
															<p><?php echo esc_html( $contact_label ); ?></p>
														</div>
														<div class="brand-contact-info">
															<a href="tel:<?php echo esc_attr( $contact_no ); ?>"><?php echo esc_html( $contact_no ); ?></a>
														</div>
													</div>
													<?php
												}
												if ( ! empty( $email_label || $email_address ) ) {
													?>
													<div class="brand-mail">
														<div class="brand-mail">
															<p><?php echo esc_html( $email_label ); ?></p>
														</div>
														<div class="brand-mail-info">
															<a href="mailto:<?php echo esc_attr( $email_address ); ?>"><?php echo esc_html( $email_address ); ?></a>
														</div>
													</div>
												<?php } ?>
											</div>
										</div>
									</div>
								</div>
								<div class="bizzweb-top-header-right">
									<div class="top-right-header-container">
										<?php
										if ( has_nav_menu( 'social' ) ) {
											wp_nav_menu(
												array(
													'container'         => 'ul',
													'menu_class'        => 'social-links',
													'theme_location'    => 'social',
													'link_before'       => '<span class="screen-reader-text">',
													'link_after'        => '</span>',
												)
											);
										}
										?>
									</div>
								</div>
							</div>	
						</div>
					</div>
				<?php } ?>
				<div class="bizzweb-navigation">
					<div class="section-wrapper"> 
						<div class="bizzweb-navigation-container">
							<!-- start of site-branding -->
							<div class="site-branding">
								<?php if ( has_custom_logo() ) { ?>
									<div class="site-logo">
										<?php the_custom_logo(); ?>
									</div>
								<?php } ?>
								<div class="site-identity">
									<?php
									if ( is_front_page() && is_home() ) :
										?>
									<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php
									else :
										?>
										<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php
									endif;
									$bizzweb_description = get_bloginfo( 'description', 'display' );
									if ( $bizzweb_description || is_customize_preview() ) :
										?>
										<p class="site-description"><?php echo $bizzweb_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
									<?php endif; ?>
								</div>	
							</div>
							<!-- end of site-branding -->

							<!-- start of navigation -->
							<nav id="site-navigation" class="main-navigation">
								<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
									<span class="ham-icon"></span>
									<span class="ham-icon"></span>
									<span class="ham-icon"></span>
									<i class="fa fa-bars" aria-hidden="true"></i>
								</button>
								<div class="navigation-area">
									<?php
									if ( has_nav_menu( 'menu-1' ) ) {
										wp_nav_menu(
											array(
												'theme_location' => 'menu-1',
												'menu_id' => 'primary-menu',
											)
										);
									}
									?>
									<!-- start of search bar -->
									<div class="bizzweb-nav-search">
										<div class="header-search-wrap">
											<div class="header-search-form">
												<?php get_search_form(); ?>
											</div>
										</div>
									</div>
									<!-- end of search bar -->
								</div>
							</nav><!-- #site-navigation -->
							<!-- start of search bar -->
							<div class="bizzweb-header-search">
								<div class="header-search-wrap">
									<a href="#" class="search-icon"><i class="fa fa-search" aria-hidden="true"></i></a>
									<div class="header-search-form">
										<?php get_search_form(); ?>
									</div>
								</div>
							</div>
							<!-- end of search bar -->
						</div>
					</div>
				</div>

			</header><!-- #masthead -->

		<?php if ( ! is_front_page() || is_home() ) { ?>
			<div class="bizzweb-main-wrapper">
				<div class="section-wrapper">
					<div class="bizzweb-container-wrapper">
					<?php } ?>
