jQuery(function($) {

/* -----------------------------------------
    Preloader
    ----------------------------------------- */
  $('#preloader').delay(1000).fadeOut();
  $('#loader').delay(1000).fadeOut("slow");

  /* -----------------------------------------
  Main Slider
  ----------------------------------------- */
  $('.banner-slider').slick({
    infinite: true,
    slidesToShow: 1,
    slidesToScroll: 1,
    prevArrow: "<button class='fa fa-chevron-left'</button>",
    nextArrow: "<button class='fa fa-chevron-right'</button>",
    arrows: true,
    dots: true,
    responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
      }
    },
    {
      breakpoint: 680,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false
      }
    },
    {
      breakpoint: 512,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false
      }
    }
    ]
  })

/* -----------------------------------------
bizzweb-toggle-button
----------------------------------------- */  
  $('.menu-toggle').click(function () {
    $(this).toggleClass('show');
  });

  /* -----------------------------------------
  Keyboard Navigation
  ----------------------------------------- */
  $(window).on('load resize', function () {
    if ($(window).width() < 992 && $(window).width() >= 768) {
      $('.main-navigation').find("a").unbind('keydown');
      $('.main-navigation').find("li").last().bind('keydown', function (e) {
        if (e.which === 9) {
          e.preventDefault();
          $('#masthead').find('.menu-toggle').focus();
        }
      });
    } else if ($(window).width() < 768) {
      $('.main-navigation').find("li").unbind('keydown');
      $('.main-navigation').find("a").last().bind('keydown', function (e) {
        if (e.which === 9) {
          e.preventDefault();
          $('#masthead').find('.menu-toggle').focus();
        }
      });
    } else {
      $('.main-navigation').find("li").unbind('keydown');
      $('.main-navigation').find("a").unbind('keydown');
    }
  });

  var primary_menu_toggle = $('#masthead .menu-toggle');
  primary_menu_toggle.on('keydown', function (e) {
    var tabKey = e.keyCode === 9;
    var shiftKey = e.shiftKey;

    if (primary_menu_toggle.hasClass('show')) {
      if (shiftKey && tabKey) {
        e.preventDefault();
        $('.main-navigation').toggleClass('toggled');
        primary_menu_toggle.removeClass('show');
      };
    }
  });

  $('.header-search-wrap').find(".search-submit").bind('keydown', function (e) {
    var tabKey = e.keyCode === 9;
    if (tabKey) {
      e.preventDefault();
      $('.search-icon').focus();
    }
  });

  $('.search-icon').on('keydown', function (e) {
    var tabKey = e.keyCode === 9;
    var shiftKey = e.shiftKey;
    if ($('.header-search-wrap').hasClass('show')) {
      if (shiftKey && tabKey) {
        e.preventDefault();
        $('.header-search-wrap').removeClass('show');
        $('.search-icon').focus();
      }
    }
  });

/* -----------------------------------------
bizzweb-counter
----------------------------------------- */ 
  $('.counter').each(function() {
    var $this = $(this),
    countTo = $this.attr('data-count');
    $({ 
      countNum: $this.text()
    }).animate({
      countNum: countTo
    },
    {
      duration: 8000,
      easing:'linear',
      step: function() {
        $this.text(Math.floor(this.countNum));
      },
      complete: function() {
        $this.text(this.countNum);
            //alert('finished');
      }
    });  
  });

/* -----------------------------------------
  bizzweb-header-search-bar
----------------------------------------- */ 
  var searchWrap = $('.header-search-wrap');
  $(".search-icon").click(function(e) {
    e.preventDefault();
    searchWrap.toggleClass("show");
    searchWrap.find('input.search-field').focus();
  });
  $(document).click(function(e) {
    if (!searchWrap.is(e.target) && !searchWrap.has(e.target).length) {
      $(".header-search-wrap").removeClass("show");
    }
  });

  /* -----------------------------------------
bizzweb-play-button
----------------------------------------- */  
  $('#play-video').magnificPopup({
    type: 'iframe',
    mainClass: 'mfp-fade',
    preloader: false,
  });

  /* -----------------------------------------
scroll-to-top-button
----------------------------------------- */  
  var BizzwebScrollBtn = $('#scroll-to-top');
  $(window).scroll(function() {
    if ($(window).scrollTop() > 400) {
      BizzwebScrollBtn.addClass('show');
    } else {
      BizzwebScrollBtn.removeClass('show');
    }
  });

  BizzwebScrollBtn.on('click', function(e) {
    e.preventDefault();
    $('html, body').animate({
      scrollTop:0
    }, '300');
  });

});
