<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bizwork
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="card-item card-blog-post">
		<?php
			if (has_post_thumbnail()) {
			?>
				<div class="card-media">
					<?php bizwork_post_thumbnail(); ?>
				</div>
				<!-- .card-media -->
			<?php 
			} 
		?>

		<div class="card-body">
			<header class="entry-header">
				<?php
				if ( 'post' === get_post_type() ) :

					if ( !is_singular()) :
						?>
							<div class="entry-meta">
								<?php
								bizwork_posted_on();
								bizwork_posted_by();
								?>
							</div><!-- .entry-meta -->
						<?php
					endif;
				
					if ( is_singular() ) :
						the_title( '<h1 class="entry-title">', '</h1>' );
					else :
						the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					endif;

					if ( is_singular() ) :
						?>
						<div class="entry-meta">
							<?php
							bizwork_posted_on();
							bizwork_posted_by();
							?>
						</div><!-- .entry-meta -->
						<?php

							$categories_list = get_the_category_list( esc_html( ' ', 'bizwork' ) );
							if ( $categories_list ) {
								/* translators: 1: list of categories. */
								printf( '<span class="cat-links">' . esc_html('%1$s', 'bizwork') .  '</span>', $categories_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							}
					endif;

					if ( !is_singular()) :
						$categories_list = get_the_category_list( esc_html__( ', ', 'bizwork' ) );
							if ( $categories_list ) {
								/* translators: 1: list of categories. */
								printf( '<span class="cat-links">' . esc_html('%1$s', 'bizwork') .  '</span>', $categories_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							}
					endif;
					?>
					
					

				<?php endif; ?>
			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php
					if ( is_singular() ) :
						the_content();
					else :
						echo "<p>".wp_trim_words(get_the_excerpt(), 15)."</p>";
						?>
						<a href="<?php the_permalink(); ?>" class="btn text-uppercase"> <?php echo esc_html(get_theme_mod('bizwork_read_more_text', __('Read More', 'bizwork'))); ?> </a>
						<?php
					endif;
					?>


				<?php
				wp_link_pages(
					array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'bizwork' ),
						'after'  => '</div>',
					)
				);
				?>
			</div><!-- .entry-content -->

			<?php
			if (is_singular()) {
			?>
				<footer class="entry-footer">
					<?php bizwork_entry_footer(); ?>
				</footer><!-- .entry-footer -->
			<?php
			}
			?>

		</div>
		<!-- .card-body -->
	</div>
	<!-- .card-item -->



</article><!-- #post-<?php the_ID(); ?> -->
