<?php
/**
 * Bizwork Theme Customizer
 *
 * @package Bizwork
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

 function bizwork_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'bizwork_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'bizwork_customize_partial_blogdescription',
			)
		);
	}

	/*
    * Theme Options Panel
    */
	$wp_customize->add_panel('bizwork_panel', array(
		'priority' => 25,
		'capability' => 'edit_theme_options',
		'title' => __('Bizwork Theme Options', 'bizwork'),
	));

	/*
	* Customizer top header section
	*/
	/*Top Header Options*/
	$wp_customize->add_section('bizwork_header_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Top Header Options', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));

	/*Top header section enable*/
	$wp_customize->add_setting(
		'bizwork_enable_top_header',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizwork_enable_top_header',
		array(
			'label'       => __('Enable Top Header', 'bizwork'),
			'description' => __('Checked to show the top header section.', 'bizwork'),
			'section'     => 'bizwork_header_section',
			'type'        => 'checkbox',
		)
	);

	/*Enable Menu at the top*/
	$wp_customize->add_setting(
		'bizwork_enable_top_menu',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizwork_enable_top_menu',
		array(
			'label'       => __('Enable Top Menu', 'bizwork'),
			'description' => __('Top menu will be enabled from here.', 'bizwork'),
			'section'     => 'bizwork_header_section',
			'type'        => 'checkbox',
		)
	);

	/*Enable Social Menu at the top*/
	$wp_customize->add_setting(
		'bizwork_enable_top_social_menu',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizwork_enable_top_social_menu',
		array(
			'label'       => __('Enable Top Social Menu', 'bizwork'),
			'description' => __('Checked to show the top social menu.', 'bizwork'),
			'section'     => 'bizwork_header_section',
			'type'        => 'checkbox',
		)
	);

	/*Enable Search Icon at the top*/
	$wp_customize->add_setting(
		'bizwork_enable_top_search_icon',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizwork_enable_top_search_icon',
		array(
			'label'       => __('Enable Top Search Section', 'bizwork'),
			'description' => __('Checked to show the Search icon.', 'bizwork'),
			'section'     => 'bizwork_header_section',
			'type'        => 'checkbox',
		)
	);

	/*
	* Customizer Footer Section
	*/
	/*Footer Options*/
	$wp_customize->add_section('bizwork_footer_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Footer Options', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));


	/*Footer Social Menu Option*/
	$wp_customize->add_setting(
		'bizwork_footer_social_menu',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizwork_footer_social_menu',
		array(
			'label'       => __('Enable Footer Social Menu', 'bizwork'),
			'description' => __('Checked to show the Footer Social Menu.', 'bizwork'),
			'section'     => 'bizwork_footer_section',
			'type'        => 'checkbox',
		)
	);

	/*Footer Copyright Text Enable*/
	$wp_customize->add_setting(
		'bizwork_copyright_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Copyright All Rights Reserved 2024', 'bizwork' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_copyright_option',
		array(
			'label'       => __('Edit Copyright Text', 'bizwork'),
			'description' => __('Edit the Footer Copyright Section.', 'bizwork'),
			'section'     => 'bizwork_footer_section',
			'type'        => 'text',
		)
	);

	/*Go To Top Option*/
	$wp_customize->add_setting(
		'bizwork_enable_go_to_top_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'bizwork_enable_go_to_top_option',
		array(
			'label'       => __('Enable Go To Top', 'bizwork'),
			'description' => __('Checked to enable Go To Top option.', 'bizwork'),
			'section'     => 'bizwork_footer_section',
			'type'        => 'checkbox',
		)
	);


	/*
	* Customizer Homepage Section
	*/
	
	// Image Variables
	$banner_img1 = get_template_directory_uri().'/cemreworks/assets/images/home-banner.png';
	$service_main_img = get_template_directory_uri().'/cemreworks/assets/images/service-img.jpg';
	$service_img1 = get_template_directory_uri().'/cemreworks/assets/images/service1.png';
	$service_img2 = get_template_directory_uri().'/cemreworks/assets/images/service2.png';
	$service_img3 = get_template_directory_uri().'/cemreworks/assets/images/service3.png';
	$testimonial_img1 = get_template_directory_uri().'/cemreworks/assets/images/testimonial.jpg';
	$testimonial_img2 = get_template_directory_uri().'/cemreworks/assets/images/testimonial2.jpg';
	$logo_img1 = get_template_directory_uri().'/cemreworks/assets/images/logoipsum-1.png';
	$logo_img2 = get_template_directory_uri().'/cemreworks/assets/images/logoipsum-2.png';
	$logo_img3 = get_template_directory_uri().'/cemreworks/assets/images/logoipsum-3.png';
	$logo_img4 = get_template_directory_uri().'/cemreworks/assets/images/logoipsum-4.png';
	

	/*Banner Options*/
	$wp_customize->add_section('bizwork_home_banner_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Banner Section', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));

	/* Enable Banner Section */
	$wp_customize->add_setting(
		'bizwork_home_banner_section_enable',
		array(
			'capability'        => 'edit_theme_options',
			'transport' => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox'
		)
	);
	$wp_customize->add_control(
		'bizwork_home_banner_section_enable',
		array(
			'label'     => __('Enable Banner Section', 'bizwork'),
			'description' => __('You can hide or show banner section', 'bizwork'),
			'section'   => 'bizwork_home_banner_section',
			'settings'  => 'bizwork_home_banner_section_enable',
			'type'      => 'checkbox',
		)
	);


	/* Banner Slider-1 Heading Option */
	$wp_customize->add_setting(
		'bizwork_banner_slider_1_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Pursue Your Passion Through Your Career.', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_banner_slider_1_heading',
		array(
			'label'       => __('Heading Text - Slider 1', 'bizwork'),
			'section'     => 'bizwork_home_banner_section',
			'type'        => 'text',
		)
	);

	/* Banner Slider-1 Sub-heading Option */
	$wp_customize->add_setting(
		'bizwork_banner_slider_1_sub_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Tailored services designed to meet your unique needs. Let us help you achieve success.', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_banner_slider_1_sub_heading',
		array(
			'label'       => __('Sub-Heading Text - Slider 1', 'bizwork'),
			'section'     => 'bizwork_home_banner_section',
			'type'        => 'text',
		)
	);

	/* Banner Slider-1 Image Option */
    $wp_customize->add_setting('bizwork_banner_slider_1_image', array(
        'default'     => $banner_img1,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_banner_slider_1_image', array(
        'label'       => __('Banner Slider Image 1', 'bizwork'),
        'section'     => 'bizwork_home_banner_section',
        'settings'    => 'bizwork_banner_slider_1_image',
        'description' => __('Upload an image for slider 1', 'bizwork'),
    )));


	/* Banner Slider-2 Heading Option */
	$wp_customize->add_setting(
		'bizwork_banner_slider_2_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Committed to Excellence', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_banner_slider_2_heading',
		array(
			'label'       => __('Heading Text - Slider 2', 'bizwork'),
			'section'     => 'bizwork_home_banner_section',
			'type'        => 'text',
		)
	);

	/* Banner Slider-2 Sub-heading Option */
	$wp_customize->add_setting(
		'bizwork_banner_slider_2_sub_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('We deliver on our promise of top-tier service and results. Let\'s build your future together.', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_banner_slider_2_sub_heading',
		array(
			'label'       => __('Sub-Heading Text - Slider 2', 'bizwork'),
			'section'     => 'bizwork_home_banner_section',
			'type'        => 'text',
		)
	);

	/* Banner Slider-2 Image Option */
    $wp_customize->add_setting('bizwork_banner_slider_2_image', array(
        'default'     => $banner_img1,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_banner_slider_2_image', array(
        'label'       => __('Banner Slider Image 2', 'bizwork'),
        'section'     => 'bizwork_home_banner_section',
        'settings'    => 'bizwork_banner_slider_2_image',
        'description' => __('Upload an image for slider 2', 'bizwork'),
    )));


	/* Service Section Options*/
	$wp_customize->add_section('bizwork_home_service_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Service Section', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));

	/* Enable Service Section */
	$wp_customize->add_setting(
		'bizwork_home_service_section_enable',
		array(
			'capability'  => 'edit_theme_options',
			'transport' => 'refresh',
			'default' => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox'
		)
	);
	$wp_customize->add_control(
		'bizwork_home_service_section_enable',
		array(
			'label'     => __('Enable Service Section', 'bizwork'),
			'description' => __('You can hide or show service section', 'bizwork'),
			'section'   => 'bizwork_home_service_section',
			'settings'  => 'bizwork_home_service_section_enable',
			'type'      => 'checkbox',
		)
	);


	/* Service Section Title Option */
	$wp_customize->add_setting(
		'bizwork_service_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Better Solutions For Your Insurance Services', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_heading',
		array(
			'label'       => __('Service Section Heading', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit service section heading', 'bizwork'),
			'type'        => 'text',
		)
	);

	/* Service Section Main Image Option */
    $wp_customize->add_setting('bizwork_service_box_main_image', array(
        'default'     => $service_main_img,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_service_box_main_image', array(
        'label'       => __('Service Section Image', 'bizwork'),
        'section'     => 'bizwork_home_service_section',
        'settings'    => 'bizwork_service_box_main_image',
        'description' => __('Upload an image for service section', 'bizwork'),
    )));

	/* Service Box 1 - Heading Option */
	$wp_customize->add_setting(
		'bizwork_service_box_1_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Fast & Easy Service', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_box_1_heading',
		array(
			'label'       => __('Service Heading', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit heading text for service box 1', 'bizwork'),
			'type'        => 'text',
		)
	);


	/* Service Box 1 - Description Option */
	$wp_customize->add_setting(
		'bizwork_service_box_1_description',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Extensive knowledge that helps us design innovative and efficient solutions.', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_box_1_description',
		array(
			'label'       => __('Service Description', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit description text for service box 1', 'bizwork'),
			'type'        => 'text',
		)
	);

	/* Service Box 1 - Image Option */
    $wp_customize->add_setting('bizwork_service_box_1_image', array(
        'default'     => $service_img1,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_service_box_1_image', array(
        'label'       => __('Service Icon Image 1', 'bizwork'),
        'section'     => 'bizwork_home_service_section',
        'settings'    => 'bizwork_service_box_1_image',
        'description' => __('Upload testimonial image 1', 'bizwork'),
    )));


	/* Service Box 2 - Heading Option */
	$wp_customize->add_setting(
		'bizwork_service_box_2_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Customized Solutions', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_box_2_heading',
		array(
			'label'       => __('Service Heading', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit heading text for service box 2', 'bizwork'),
			'type'        => 'text',
		)
	);


	/* Service Box 2 - Description Option */
	$wp_customize->add_setting(
		'bizwork_service_box_2_description',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Flexibility in service offerings to grow and scale with your business.', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_box_2_description',
		array(
			'label'       => __('Service Description', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit description text for service box 2', 'bizwork'),
			'type'        => 'text',
		)
	);

	/* Service Box 2 - Image Option */
    $wp_customize->add_setting('bizwork_service_box_2_image', array(
        'default'     => $service_img2,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_service_box_2_image', array(
        'label'       => __('Service Icon Image 2', 'bizwork'),
        'section'     => 'bizwork_home_service_section',
        'settings'    => 'bizwork_service_box_2_image',
        'description' => __('Upload an image for service box 2', 'bizwork'),
    )));

	/* Service Box 3 - Heading Option */
	$wp_customize->add_setting(
		'bizwork_service_box_3_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Client-Centered Approach', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_box_3_heading',
		array(
			'label'       => __('Service Heading', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit heading text for service box 3', 'bizwork'),
			'type'        => 'text',
		)
	);


	/* Service Box 2 - Description Option */
	$wp_customize->add_setting(
		'bizwork_service_box_3_description',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('A collaborative partnership where your feedback drives continuous improvement.', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_service_box_3_description',
		array(
			'label'       => __('Service Description', 'bizwork'),
			'section'     => 'bizwork_home_service_section',
			'description' => __('Edit description text for service box 3', 'bizwork' ),
			'type'        => 'text',
		)
	);

	/* Service Box 3 - Image Option */
    $wp_customize->add_setting('bizwork_service_box_3_image', array(
        'default'     => $service_img3,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_service_box_3_image', array(
        'label'       => __('Service Icon Image 3', 'bizwork'),
        'section'     => 'bizwork_home_service_section',
        'settings'    => 'bizwork_service_box_3_image',
        'description' => __('Upload an image for service box 3', 'bizwork'),
    )));


	/* Testimonial Section Options*/
	$wp_customize->add_section('bizwork_home_testimonial_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Testimonial Section', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));

	/* Enable Testimonial Section */
	$wp_customize->add_setting(
		'bizwork_home_testimonial_section_enable',
		array(
			'capability'        => 'edit_theme_options',
			'transport' => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox'
		)
	);
	$wp_customize->add_control(
		'bizwork_home_testimonial_section_enable',
		array(
			'label'     => __('Enable Testimonial Section', 'bizwork'),
			'description' => __('You can hide or show testimonial section', 'bizwork'),
			'section'   => 'bizwork_home_testimonial_section',
			'settings'  => 'bizwork_home_testimonial_section_enable',
			'type'      => 'checkbox',
		)
	);


	/* Testimonial Section Title Option */
	$wp_customize->add_setting(
		'bizwork_testimonial_heading',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Testimonials', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_testimonial_heading',
		array(
			'label'       => __('Testimonial Section Heading', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'type'        => 'text',
		)
	);

	/* Testimonial 1 - Heading Option */
	$wp_customize->add_setting(
		'bizwork_testimonial_1_name',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Emma Doe', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_testimonial_1_name',
		array(
			'label'       => __('Testimonial Title 1', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'description' => __('Edit name', 'bizwork'),
			'type'        => 'text',
		)
	);


	/* Testimonial 1 - Post Option */
	$wp_customize->add_setting(
		'bizwork_testimonial_1_post',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('CEO', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_testimonial_1_post',
		array(
			'label'       => __('Testimonial Post 1', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'description' => __('Edit post', 'bizwork'),
			'type'        => 'text',
		)
	);

	/* Testimonial 1 - Image Option */
    $wp_customize->add_setting('bizwork_testimonial_1_image', array(
        'default'     => $testimonial_img1,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_testimonial_1_image', array(
        'label'       => __('Testimonial Image 1', 'bizwork'),
        'section'     => 'bizwork_home_testimonial_section',
        'settings'    => 'bizwork_testimonial_1_image',
        'description' => __('Upload an image for service box 1', 'bizwork'),
    )));

	/* Testimonial 1 - Content Option */
	  $wp_customize->add_setting(
		'bizwork_testimonial_1_content',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('We needed a partner who could offer innovative solutions to help us stay competitive in a fast-changing market. They exceeded our expectations by providing cutting-edge strategies that have made a significant difference to our business. Highly recommend them!', 'bizwork'),
			'sanitize_callback' => 'wp_kses_post',
		)
	);
	
	$wp_customize->add_control(
		'bizwork_testimonial_1_content',
		array(
			'label'       => __('Testimonial Content 1', 'bizwork'),
			'description' => __('You can use HTML tags here to link.', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'type'        => 'textarea',
		)
	);


	/* Testimonial 2 - Heading Option */
	$wp_customize->add_setting(
		'bizwork_testimonial_2_name',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Joe Goldberg', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_testimonial_2_name',
		array(
			'label'       => __('Testimonial Title 2', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'description' => __('Edit name', 'bizwork'),
			'type'        => 'text',
		)
	);


	/* Testimonial 2 - Post Option */
	$wp_customize->add_setting(
		'bizwork_testimonial_2_post',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('Manager', 'bizwork'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'bizwork_testimonial_2_post',
		array(
			'label'       => __('Testimonial Post 2', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'description' => __('Edit post', 'bizwork'),
			'type'        => 'text',
		)
	);

	/* Testimonial 2 - Image Option */
    $wp_customize->add_setting('bizwork_testimonial_2_image', array(
        'default'     => $testimonial_img2,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_testimonial_2_image', array(
        'label'       => __('Testimonial Image 2', 'bizwork'),
        'section'     => 'bizwork_home_testimonial_section',
        'settings'    => 'bizwork_testimonial_2_image',
        'description' => __('Upload testimonial image 2', 'bizwork'),
    )));

	/* Testimonial Content 2 Option */
	  $wp_customize->add_setting(
		'bizwork_testimonial_2_content',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => __('The team is always responsive and willing to go the extra mile to ensure we’re satisfied. Their customer service is second to none, and they’ve helped us resolve every issue quickly and efficiently. We wouldn’t trust anyone else.', 'bizwork'),
			'sanitize_callback' => 'wp_kses_post',
		)
	);
	
	$wp_customize->add_control(
		'bizwork_testimonial_2_content',
		array(
			'label'       => __('Testimonial Content 2', 'bizwork'),
			'description' => __('You can use HTML tags here to link.', 'bizwork'),
			'section'     => 'bizwork_home_testimonial_section',
			'type'        => 'textarea',
		)
	);

	/* Latest Blog Section */
	$wp_customize->add_section('bizwork_home_blog_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Latest Blog Section', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));

	/* Enable Latest Blog Section */
	$wp_customize->add_setting(
		'bizwork_home_blog_section_enable',
		array(
			'capability'        => 'edit_theme_options',
			'transport' => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox'
		)
	);
	$wp_customize->add_control(
		'bizwork_home_blog_section_enable',
		array(
			'label'     => __('Enable Latest Blog Section', 'bizwork'),
			'description' => __('You can hide or show blog section', 'bizwork'),
			'section'   => 'bizwork_home_blog_section',
			'settings'  => 'bizwork_home_blog_section_enable',
			'type'      => 'checkbox',
		)
	);

	/*Featured Image Option*/
	$wp_customize->add_setting(
		'bizwork_home_blog_featured_image',
		array(
			'capability'        => 'edit_theme_options',
			'transport' => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox'
		)
	);
	$wp_customize->add_control(
		'bizwork_home_blog_featured_image',
		array(
			'label'     => __('Enable Featured Image', 'bizwork'),
			'description' => __('You can hide or show featured image', 'bizwork'),
			'section'   => 'bizwork_home_blog_section',
			'settings'  => 'bizwork_home_blog_featured_image',
			'type'      => 'checkbox',
		)
	);

	/* Logo Section Section */
	$wp_customize->add_section('bizwork_home_logo_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Logo Section', 'bizwork'),
		'panel'       => 'bizwork_panel',
	));

	/* Enable Client Logo Blog Section */
	$wp_customize->add_setting(
		'bizwork_home_logo_section_enable',
		array(
			'capability'        => 'edit_theme_options',
			'transport' => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'bizwork_sanitize_checkbox'
		)
	);
	$wp_customize->add_control(
		'bizwork_home_logo_section_enable',
		array(
			'label'     => __('Enable Client Logo Section', 'bizwork'),
			'description' => __('You can hide or show logo section', 'bizwork'),
			'section'   => 'bizwork_home_logo_section',
			'settings'  => 'bizwork_home_logo_section_enable',
			'type'      => 'checkbox',
		)
	);

	/* Logo 1 Option */
    $wp_customize->add_setting('bizwork_logo_1', array(
        'default'     => $logo_img1,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_logo_1', array(
        'label'       => __('Logo 1', 'bizwork'),
        'section'     => 'bizwork_home_logo_section',
        'settings'    => 'bizwork_logo_1',
        'description' => __('Upload image', 'bizwork'),
		'height'=>40, 'width'=>170, 'flex_width'=>true, 'flex_height'=>true,
		
    )));

	/* Logo 2 Option */
    $wp_customize->add_setting('bizwork_logo_2', array(
        'default'     => $logo_img2,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_logo_2', array(
        'label'       => __('Logo 2', 'bizwork'),
        'section'     => 'bizwork_home_logo_section',
        'settings'    => 'bizwork_logo_2',
        'description' => __('Upload image', 'bizwork'),
		'height'=>40, 'width'=>170, 'flex_width'=>true, 'flex_height'=>true,
    )));

	/* Logo 3 Option */
    $wp_customize->add_setting('bizwork_logo_3', array(
        'default'     => $logo_img3,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_logo_3', array(
        'label'       => __('Logo 3', 'bizwork'),
        'section'     => 'bizwork_home_logo_section',
        'settings'    => 'bizwork_logo_3',
        'description' => __('Upload image', 'bizwork'),
		'height'=>40, 'width'=>170, 'flex_width'=>true, 'flex_height'=>true,
    )));

	/* Logo 4 Option */
    $wp_customize->add_setting('bizwork_logo_4', array(
        'default'     => $logo_img4,
        'transport'   => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'bizwork_logo_4', array(
        'label'       => __('Logo 4', 'bizwork'),
        'section'     => 'bizwork_home_logo_section',
        'settings'    => 'bizwork_logo_4',
        'description' => __('Upload image', 'bizwork'),
		
    )));

}
add_action( 'customize_register', 'bizwork_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function bizwork_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function bizwork_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function bizwork_customize_preview_js() {
	wp_enqueue_script( 'bizwork-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), _S_VERSION, true );
}
add_action( 'customize_preview_init', 'bizwork_customize_preview_js' );
