<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bizwork
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'bizwork' ); ?></a>

	<header id="masthead" class="site-header">

	<?php 
	$top_header = absint(get_theme_mod('bizwork_enable_top_header', 1));

	//has header image
	$has_header_image = has_header_image();

	if($top_header == 1){ 
		?>
		<div class='header-top-toggle mbl-show text-center'>
			<a href='#'> <i class='fas fa-chevron-down'></i> </a>
		</div>
		<div class="top-header-wrap mbl-hide">
			<div class="container">
				<div class="flex-row">
					<div class="top-header-left">
						<?php 
						$top_header_left_menu = absint(get_theme_mod('bizwork_enable_top_menu', 1));
						if($top_header_left_menu == 1){ 
						?>
						<nav class="top-menu">
							
						<?php
                                $top_header_left_menu = absint(get_theme_mod('bizwork_enable_top_menu', 1));
                                if (($top_header_left_menu == 1) && (has_nav_menu('top-menu'))) {
                                ?>
                                    <nav class="top-menu">
                                        <?php
                                        wp_nav_menu(
                                            array(
                                                'theme_location' => 'top-menu',
                                                'menu_id'        => 'top-menu',
                                                'depth'          => 1
                                            )
                                        );
                                        ?>
                                    </nav><!-- #site-navigation -->
                                <?php } ?>
						</nav><!-- #site-navigation -->
						<?php } ?>
					</div>

					<div class="top-header-right">
						<?php 
						$top_header_social = absint(get_theme_mod('bizwork_enable_top_social_menu', 1));
						if($top_header_social == 1){ 
						?>
						<div class="social-links">
							<?php
								bizwork_social_menu();
							?>
						</div>
						<!-- .social-links -->
						<?php } 

						$top_header_search = absint(get_theme_mod('bizwork_enable_top_search_icon', 1));
						if($top_header_search == 1){ 
						?> 
						<div class="top-search search-box mbl-hide">
							<button class="search-toggle"><i class="fa fa-search"></i></button>
							<button class="close-btn"><i class="fa fa-times"></i></button>
							<div class="search-section">
								<?php get_search_form(); ?>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="main-header-wrap" <?php if (!empty($has_header_image)) { ?> style="background-image: url(<?php echo header_image(); ?>);" <?php } ?>>
			<div class="container">
				<div class="main-header flex-row">
					<div class="site-branding">
						<?php
						the_custom_logo();
						if ( is_front_page() && is_home() ) :
							?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php
						else :
							?>
							<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php
						endif;
						$bizwork_description = get_bloginfo( 'description', 'display' );
						if ( $bizwork_description || is_customize_preview() ) :
							?>
							<p class="site-description"><?php echo $bizwork_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
						<?php endif; ?>
					</div><!-- .site-branding -->

					<nav id="site-navigation" class="main-navigation">

						<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><i class="fas fa-bars"></i></button>
						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
							)
						);
					?>
					</nav><!-- #site-navigation -->
					<?php 
						$top_header_search = absint(get_theme_mod('bizwork_enable_top_search_icon', 1));
						if($top_header_search == 1){ 
						?>
						<div class="top-search search-box mbl-show">
							<button class="search-toggle"><i class="fa fa-search"></i></button>
							<button class="close-btn"><i class="fa fa-times"></i></button>
							<div class="search-section">
								<?php get_search_form(); ?>
							</div>
						</div>
						<?php } ?>

				</div>	
			</div>
		</div>
	</header><!-- #masthead -->
