<?php
/**
 * Bizwork functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Bizwork
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function bizwork_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on Bizwork, use a find and replace
		* to change 'bizwork' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'bizwork' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'bizwork' ),
			'top-menu' => esc_html__('Top Menu', 'bizwork'),
			'social-menu' => esc_html__('Social Menu', 'bizwork'),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'bizwork_custom_background_args',
			array(
				'default-color' => '#FBF8F1',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'bizwork_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function bizwork_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'bizwork_content_width', 640 );
}
add_action( 'after_setup_theme', 'bizwork_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function bizwork_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'bizwork' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'bizwork' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'bizwork' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here.', 'bizwork' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'bizwork' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here.', 'bizwork' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'bizwork' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here.', 'bizwork' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'bizwork_widgets_init' );


function bizwork_social_menu()
    {
        if (has_nav_menu('social-menu')) :
            wp_nav_menu(array(
                'theme_location' => 'social-menu',
                'container' => 'ul',
                'menu_class' => 'social-menu menu',
                'menu_id'  => 'menu-social',
            ));
        endif;
    }

/**
 * Enqueue scripts and styles.
 */
function bizwork_scripts() {

	// Load fonts locally
	require_once get_theme_file_path('inc/wptt-webfont-loader.php');

	$font_families = array(
		'Nunito:wght@300;400;500;600;700',
		'Andika:wght@300;400;500;600;700'
	);
	
	$fonts_url = add_query_arg( array(
		'family' => implode( '&family=', $font_families ),
		'display' => 'swap',
	), 'https://fonts.googleapis.com/css2' );

	wp_enqueue_style('bizwork-google-fonts', wptt_get_webfont_url(esc_url_raw($fonts_url)), array(), '1.0.0');

	
	// Font Awesome CSS
	wp_enqueue_style('font-awesome-5', get_template_directory_uri() . '/cemreworks/assets/vendors/font-awesome-5/css/all.min.css', array());
	wp_enqueue_style('slick', get_template_directory_uri() . '/cemreworks/assets/vendors/slick/slick.css', array(), _S_VERSION);
	wp_enqueue_style('slick-theme', get_template_directory_uri() . '/cemreworks/assets/vendors/slick/slick-theme.css', array(), _S_VERSION);
	
	
	wp_enqueue_style( 'bizwork-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'bizwork-style', 'rtl', 'replace' );

	wp_enqueue_script('slick', get_template_directory_uri() . '/cemreworks/assets/vendors/slick/slick.js', array('jquery'), _S_VERSION, true);
	wp_enqueue_script( 'bizwork-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );
	wp_enqueue_script('customizer-js', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), '1.0', true);

	wp_enqueue_script( 'bizwork-custom-js', get_template_directory_uri() . '/cemreworks/assets/js/custom.js', array('jquery'), _S_VERSION, true );

	wp_enqueue_script( 'theia-sticky-sidebar', get_template_directory_uri() . '/cemreworks/assets/js/theia-sticky-sidebar.js', array('jquery'), _S_VERSION, true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'bizwork_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Checkbox sanitization callback example.
 *
 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$checked`
 * as a boolean value, either TRUE or FALSE.
 *
 * @param bool $checked Whether the checkbox is checked.
 * @return bool Whether the checkbox is checked.
 */
function bizwork_sanitize_checkbox($checked)
{
    // Boolean check.
    return ((isset($checked) && true == $checked) ? true : false);
}


if (!function_exists('bizwork_related_post')) :
    /**
     * Display related posts from same category
     *
     * @param int $post_id
     * @return void
     *
     * @since 1.0.0
     *
     */
    function bizwork_related_post($post_id)
    {

        
        $categories = get_the_category($post_id);
        if ($categories) {
            $category_ids = array();
            $category = get_category($category_ids);
            $categories = get_the_category($post_id);
            foreach ($categories as $category) {
                $category_ids[] = $category->term_id;
            }
            $count = $category->category_count;
            if ($count > 1) { ?>
                <div class="related-post">
                    
                    <h2 class="post-title">related Posts</h2>
                    <?php
                    $bizwork_cat_post_args = array(
                        'category__in' => $category_ids,
                        'post__not_in' => array($post_id),
                        'post_type' => 'post',
                        'posts_per_page' => 3,
                        'post_status' => 'publish',
                        'ignore_sticky_posts' => true
                    );
                    $bizwork_featured_query = new WP_Query($bizwork_cat_post_args);
                    ?>
                    <div class="rel-post-wrap">
                        <?php
                        if ($bizwork_featured_query->have_posts()) :

                        while ($bizwork_featured_query->have_posts()) : $bizwork_featured_query->the_post();
                            ?>

							<div class="card-item rel-card-item">
								<?php
									if(has_post_thumbnail()){
									?>

									<div class="card-media"> 
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail(); ?>
											
										</a>
									</div>
									<?php
									}
								?>
								<div class="card-content">
									<div class="entry-title">
										<h3>
											<a href="<?php the_permalink() ?>">
												<?php the_title(); ?>
											</a>
										</h3>
									</div>
									<div class="entry-meta">
										<?php bizwork_posted_on(); ?>
									</div>
								</div>
							</div>

				


                        <?php
                        endwhile;
                        ?>
                <?php
                endif;
                wp_reset_postdata();
                ?>
                </div> <!-- .related-post -->
                <?php
            }
        }
    }
endif;
add_action('bizwork_related_posts', 'bizwork_related_post', 10, 1);

function bixwork_excerpt_length( $length ) {
	return 22;
	}
	add_filter( 'excerpt_length', 'bixwork_excerpt_length', 999 );
