<?php
/**
 * The front page template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bizwork
 */

get_header();
?>
    <main class="site-main home">
    <?php 
    $section_banner = absint(get_theme_mod('bizwork_home_banner_section_enable', 1));
    if($section_banner == 1){ 
    ?>
        <section class="home-banner-wrap">
            <div class="container">
                <div class="home-banner-slider">
                    <div class="home-banner-item">
                        <div class="home-banner">
                            <div class="home-banner-left">                                
                                <h1 class="banner-title">
                                    <?php echo esc_html(get_theme_mod('bizwork_banner_slider_1_heading', __('Pursue Your Passion Through Your Career.', 'bizwork'))); ?>
                                </h1>
                                <div class="banner-subtitle">
                                    <?php echo esc_html(get_theme_mod('bizwork_banner_slider_1_sub_heading', __('Tailored services designed to meet your unique needs. Let us help you achieve success.', 'bizwork')));?>
                                </div>
                            </div>
                            <div class="home-banner-right">
                                <div class="img-wrapper">
                                    <img src="<?php echo esc_url( get_theme_mod('bizwork_banner_slider_1_image',''.get_template_directory_uri().'/cemreworks/assets/images/home-banner.png')); ?>" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- .home-banner-item -->

                    <div class="home-banner-item">
                        <div class="home-banner">
                            <div class="home-banner-left">
                                <h2 class="banner-title">
                                    <?php echo esc_html(get_theme_mod('bizwork_banner_slider_2_heading', __('Committed to Excellence', 'bizwork'))); ?>
                                </h2>
                                <div class="banner-subtitle">
                                    <?php echo esc_html(get_theme_mod('bizwork_banner_slider_2_sub_heading', __('We deliver on our promise of top-tier service and results. Let\'s build your future together.', 'bizwork'))); ?>
                                </div>
                            </div>
                            <div class="home-banner-right">
                                <div class="img-wrapper">
                                    <img src="<?php echo esc_url( get_theme_mod('bizwork_banner_slider_2_image',''.get_template_directory_uri().'/cemreworks/assets/images/home-banner.png')); ?>" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- .home-banner-item -->

                </div>
                
                
            </div>
        </section>
        <!-- .home-banner-wrap -->  
    <?php } ?>
                                
    <?php 
    $section_service = absint(get_theme_mod('bizwork_home_service_section_enable', 1));
    if($section_service == 1){ 
    ?>
        <section class="service-section-wrap">
            <div class="container">
                <div class="service-section bw-flex">
                    <div class="service-left bw-left">
                        <h2>
                            <?php echo esc_html(get_theme_mod('bizwork_service_heading', __('Better Solutions For Your Insurance Services', 'bizwork'))); ?>
                            
                        </h2>

                        <div class="service-item-wrap bw-flex">
                            <div class="service-item">
                                <div class="service-img">
                                    <img src="<?php echo esc_url( get_theme_mod('bizwork_service_box_1_image',''.get_template_directory_uri().'/cemreworks/assets/images/service1.png')); ?>" alt="">
                                </div>
                                <div class="service-content">
                                    <h4 class="service-title">
                                        <?php echo esc_html(get_theme_mod('bizwork_service_box_1_heading', __('Fast & Easy Service', 'bizwork'))); ?>
                                    </h4>
                                    <p>
                                        <?php echo esc_html(get_theme_mod('bizwork_service_box_1_description', __('Extensive knowledge that helps us design innovative and efficient solutions.', 'bizwork'))); ?>
                                    </p>
                                </div>
                            </div>

                            <div class="service-item">
                                <div class="service-img">
                                    <img src="<?php echo esc_url( get_theme_mod('bizwork_service_box_2_image',''.get_template_directory_uri().'/cemreworks/assets/images/service2.png')); ?>" alt="">
                                </div>
                                <div class="service-content">
                                    <h4 class="service-title">
                                        <?php echo esc_html(get_theme_mod('bizwork_service_box_2_heading', __('Customized Solutions', 'bizwork'))); ?>
                                    </h4>
                                    <p>
                                        <?php echo esc_html(get_theme_mod('bizwork_service_box_1_description', __('Flexibility in service offerings to grow and scale with your business.', 'bizwork'))); ?>
                                    </p>
                                </div>
                            </div>

                            <div class="service-item">
                                <div class="service-img">
                                    <img src="<?php echo esc_url( get_theme_mod('bizwork_service_box_3_image',''.get_template_directory_uri().'/cemreworks/assets/images/service3.png')); ?>" alt="">
                                </div>
                                <div class="service-content">
                                    <h4 class="service-title">
                                        <?php echo esc_html(get_theme_mod('bizwork_service_box_3_heading', __('Client-Centered Approach', 'bizwork'))); ?>
                                    </h4>
                                    <p>
                                        <?php echo esc_html(get_theme_mod('bizwork_service_box_1_description', __('A collaborative partnership where your feedback drives continuous improvement.', 'bizwork'))); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="service-right bw-right">
                        <div class="img-wrapper">
                            <img src="<?php echo esc_url( get_theme_mod('bizwork_service_box_main_image',''.get_template_directory_uri().'/cemreworks/assets/images/service-img.jpg')); ?>" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>


    <?php 
    $section_testimonial = absint(get_theme_mod('bizwork_home_testimonial_section_enable', 1));
    if($section_testimonial == 1){ 
    ?>
        <section class="testimonial-wrap">
            <div class="container">
                <h2 class="text-center">
                    <?php _e('Testimonials', 'bizwork'); ?>
                </h2>
                <div class="testimonial-section">
                    <div class="testimonial-item">
                        <div class="testimonial-content">
                            <p>
                                <?php echo esc_html(get_theme_mod('bizwork_testimonial_1_content', __('We needed a partner who could offer innovative solutions to help us stay competitive in a fast-changing market. They exceeded our expectations by providing cutting-edge strategies that have made a significant difference to our business. Highly recommend them!', 'bizwork'))); ?>
                            </p>
                        </div>
                        <div class="testimonial-detail">
                            <div class="testimonial-img">
                                <img src="<?php echo esc_url( get_theme_mod('bizwork_testimonial_1_image',''.get_template_directory_uri().'/cemreworks/assets/images/testimonial.jpg')); ?>" alt="">
                            </div>
                            <div class="testimonial-meta">
                                <div class="testimonial-title">
                                    <?php echo esc_html(get_theme_mod('bizwork_testimonial_1_name', __('John Cena', 'bizwork'))); ?>
                                </div>
                                <div class="testimonial-post">
                                    <?php echo esc_html(get_theme_mod('bizwork_testimonial_1_post', __('CEO', 'bizwork'))); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- .testimonial-item -->


                    <div class="testimonial-item">
                        <div class="testimonial-content">
                            <p>
                                <?php echo esc_html(get_theme_mod('bizwork_testimonial_2_content', __('The team is always responsive and willing to go the extra mile to ensure we’re satisfied. Their customer service is second to none, and they’ve helped us resolve every issue quickly and efficiently. We wouldn’t trust anyone else.', 'bizwork'))); ?>
                            </p>
                        </div>
                        <div class="testimonial-detail">
                            <div class="testimonial-img">
                                <img src="<?php echo esc_url( get_theme_mod('bizwork_testimonial_2_image',''.get_template_directory_uri().'/cemreworks/assets/images/testimonial2.jpg')); ?>" alt="">
                            </div>
                            <div class="testimonial-meta">
                                <div class="testimonial-title">
                                    <?php echo esc_html(get_theme_mod('bizwork_testimonial_2_name', __('Joe Goldberg', 'bizwork'))); ?>
                                </div>
                                <div class="testimonial-post">
                                    <?php echo esc_html(get_theme_mod('bizwork_testimonial_2_post', __('Manager', 'bizwork'))); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- .testimonial-item -->
                </div>
            </div>
        </section>
    <?php } ?>

    <?php 
    $section_blog = absint(get_theme_mod('bizwork_home_blog_section_enable', 1));
    $featured_img_blog = absint(get_theme_mod('bizwork_home_blog_featured_image', 1));

    if($section_blog == 1){ 
    ?>
        <main id="primary" class="site-main">
        <section class="blog-section-wrap">
            <div class="container">
                <h2 class="text-center"><?php _e('Our Latest Blog', 'bizwork'); ?></h2>
                <div class="blog-section">
                <?php
                    // Start the loop
                    $args = array(
                        'post_type' => 'post',  // Define post type to be 'post' for blog posts
                        'posts_per_page' => 6, // Number of posts to display
                    );
                    $the_query = new WP_Query($args);

                    if ($the_query->have_posts()) : 
                        while ($the_query->have_posts()) : $the_query->the_post(); 
                    ?>

                        <!-- Output the post title and excerpt -->
                        <div class="blog-post">
                            <?php
                            if($featured_img_blog == 1){
                                if (has_post_thumbnail()) {
                                ?>
                                    <div class="post-media">
                                        <?php bizwork_post_thumbnail(get_the_ID(), 'medium'); ?>
                                    </div>
                                    <!-- .card-media -->
                                <?php 
                                } 
                            }
                            
                            ?>
                            <div class="post-content">
                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                <div class="post-excerpt">
                                    <?php the_excerpt(15); ?>
                                </div>
                            </div>
                            
                        </div>

                    <?php 
                        endwhile;
                        wp_reset_postdata(); // Reset the global post object
                    else : 
                    ?>

                        <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'bizwork'); ?></p>

                    <?php 
                    endif;
                    ?>
                </div>
            </div>
        </section>
                </main>
    <?php } ?>

    <?php 
    $section_logo = absint(get_theme_mod('bizwork_home_logo_section_enable', 1));
    if($section_logo == 1){ 
    ?>
        <section class="clients-section-wrap">
            <div class="container">
                <div class="client-section">
                    <h3><?php _e('Our Clients', 'bizwork'); ?></h3>
                    <div class="client-logo-wrap">
                        <div class="logo-wrap">
                            <img src="<?php echo esc_url( get_theme_mod('bizwork_logo_1',''.get_template_directory_uri().'/cemreworks/assets/images/logoipsum-1.png')); ?>" alt="">
                        </div>
                        <div class="logo-wrap">
                            <img src="<?php echo esc_url( get_theme_mod('bizwork_logo_2',''.get_template_directory_uri().'/cemreworks/assets/images/logoipsum-2.png')); ?>" alt="">
                        </div>
                        <div class="logo-wrap">
                            <img src="<?php echo esc_url( get_theme_mod('bizwork_logo_3',''.get_template_directory_uri().'/cemreworks/assets/images/logoipsum-3.png')); ?>" alt="">
                        </div>
                        <div class="logo-wrap">
                            <img src="<?php echo esc_url( get_theme_mod('bizwork_logo_4',''.get_template_directory_uri().'/cemreworks/assets/images/logoipsum-4.png')); ?>" alt="">
                        </div>
                    
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
    </main>



<?php
get_footer();
