<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bizwork
 */

?>

	<footer id="colophon" class="site-footer">
		<?php 
			if (is_active_sidebar('footer-1') || is_active_sidebar('footer-2') || is_active_sidebar('footer-3')) {
				?>
				<section class="footer-top">
					<div class="container">
						<div class="flex-row">
							<?php
							if (is_active_sidebar('footer-1')) {
							?>
								<div class="footer-col">
									<?php dynamic_sidebar('footer-1'); ?>
								</div>
							<?php
							}
							if (is_active_sidebar('footer-2')) {
							?>
	
								<div class="footer-col">
									<?php dynamic_sidebar('footer-2'); ?>
								</div>
							<?php
							}
							if (is_active_sidebar('footer-3')) {
							?>
								<div class="footer-col">
									<?php dynamic_sidebar('footer-3'); ?>
								</div>
							<?php
							}
							?>
						</div>
					</div>
				</section>
			<?php
			}
		?>

		<div class="footer-bottom">
			<div class="container">
				<?php 
				$footer_social = absint(get_theme_mod('bizwork_footer_social_menu', 1));
				if($footer_social == 1){ 
				?>
				<div class="social-links">
					<?php
						bizwork_social_menu();
					?>
				</div>
				<?php 
				} 
				?>
				<div class="site-info">
					<div>
					<?php 
						echo esc_html(get_theme_mod('bizwork_copyright_option', __('Copyright All Rights Reserved © 2024', 'bizwork')));
					?>
					</div>
					<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'bizwork' ) ); ?>">
						<?php
						/* translators: %s: CMS name, i.e. WordPress. */
						printf( esc_html__( 'Proudly powered by %s', 'bizwork' ), 'WordPress' );
						?>
					</a>
					<span class="sep"> | </span>
						<?php
						/* translators: 1: Theme name, 2: Theme author. */
						printf( esc_html__( 'Theme: %1$s by %2$s.', 'bizwork' ), 'Bizwork', '<a href="https://cemreworks.com/">Cemre Works</a>' );
						?>
				</div>
			</div>
		</div>
		<!-- .footer-bottom -->
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php 
	$footer_go_to_top = absint(get_theme_mod('bizwork_enable_go_to_top_option', 1));
	if($footer_go_to_top == 1){ 
		?>
		<a href="javascript:void(0);" class="footer-go-to-top go-to-top"><i class="fas fa-chevron-up"></i></a>
<?php } ?>

<?php wp_footer(); ?>

</body>
</html>
