
jQuery(document).ready(function ($) {
    // HEADER SEARCH BOX SCRIPTS
    if (jQuery(".search-box").length > 0) {
        $(".site-header .search-toggle").on("click", function () {
            $(".site-header .search-toggle").addClass("hide");
            $(".search-box .close-btn").addClass("show");
            $(".search-box .search-section").slideToggle();
            $('.search-box').addClass('search-box-toggled');
            $('.search-box .search-form .search-field').focus();
            $('.search-box.search-box-toggled').on("keydown", function (e) {
                var focusableEls = $(
                    ".search-box-toggled .close-btn, .search-box-toggled input"
                );
                var firstFocusableEl = focusableEls[0];
                var lastFocusableEl = focusableEls[focusableEls.length - 1];
                var KEYCODE_TAB = 9;
                if (e.key === "Tab" || e.keyCode === KEYCODE_TAB) {
                    if (e.shiftKey) {
                    /* shift + tab */ if (
                            document.activeElement.className === firstFocusableEl.className
                        ) {

                            $('.' + lastFocusableEl.className).focus();
                            e.preventDefault();
                        }
                    } /* tab */ else {

                        if (document.activeElement.value === lastFocusableEl.value) {
                            $('.search-box-toggled .close-btn.show').focus();
                            e.preventDefault();
                        }
                    }
                }
            });
        });

        $(".search-box .close-btn").on("click", function () {
            var CloseButton = $(".search-box .close-btn");
            if (CloseButton.length < 0) {
                $(this).addClass("show");
            } else {
                $(this).removeClass("show") &&
                    $(".search-box .search-section").slideUp() &&
                    $(".site-header .search-toggle").removeClass("hide");

                $(".search-box .search-toggle").focus();
            }
        });
    }

    if ($(".home-banner-slider").length > 0) {
        $(".home-banner-slider").slick({
            items: 1,
            dots: true,
            arrows: false,
            autoplay: true,
            infinite: true,
            centerMode: false,
            lazyLoad: "ondemand",
            adaptiveHeight: true,
        });
    }

    /*
    ** ### Back to top function
    */

    if ($('.go-to-top').length) {
        var scrollTrigger = $('body').position(); // px
        goToTop = function () {

            var scrollTop = $(window).scrollTop();
            if (scrollTop > 150) {
                $('.footer-go-to-top').addClass('show');
            } else {
                $('.footer-go-to-top').removeClass('show');
            }
        };
        goToTop();
        $(window).on('scroll', function () {
            goToTop();
        });
        $('.go-to-top').on('click', function (e) {
            e.preventDefault();
            $('html,body').animate({
                scrollTop: scrollTrigger.top
            }, 700);
        });
    }

    // Top Header Mobile Toggle
    if (jQuery('.header-top-toggle').length > 0) {
        $('.header-top-toggle a').on('click', function (e) {
            console.log('clickeed');
            e.preventDefault();
            $(this).toggleClass('open');
            $('.top-header-wrap').slideToggle('mbl-hide');
        });
    }

    //sticky sidebar
    var at_body = $("body");
    var at_window = $(window);

    if (at_body.hasClass('ct-sticky-sidebar')) {
        $('#secondary, #primary').theiaStickySidebar();

    }

    // Mobile Menu Focus
    var width = $(window).width();
    if (width < 992) {
        $('.main-navigation').on('keydown', function (e) {
            if ($('.main-navigation').hasClass('toggled')) {
                var focusableEls = $('.main-navigation a[href]:not([disabled]), .main-navigation button');
                var firstFocusableEl = focusableEls[0];
                var lastFocusableEl = focusableEls[focusableEls.length - 1];
                var KEYCODE_TAB = 9;
                var KEYCODE_ESC = 27;
                if (e.key === 'Tab' || e.keyCode === KEYCODE_TAB) {
                    if (e.shiftKey) /* shift + tab */ {
                        if (document.activeElement === firstFocusableEl) {
                            lastFocusableEl.focus();
                            e.preventDefault();
                        }
                    }
                    else /* tab */ {
                        if (document.activeElement === lastFocusableEl) {
                            firstFocusableEl.focus();
                            e.preventDefault();
                        }
                    }
                }

                if (e.keyCode === KEYCODE_ESC) {
                    console.log(e.keyCode);
                    $('.main-navigation').removeClass('toggled');
                    return;
                }
            }

        });
    }


});

