<?php
class Bizway_Customizer {
    public static function Bizway_Register($wp_customize) {
        self::Bizway_Sections($wp_customize);
        self::Bizway_Controls($wp_customize);
    }
    public static function Bizway_Sections($wp_customize) {
        /**
         * General Section
         */
        $wp_customize->add_section('general_setting', array(
            'title' => __('General Settings', 'bizway'),
            'description' => __('Allows you to customize header logo, favicon etc settings for Bizway Theme.', 'bizway'), //Descriptive tooltip
            'panel' => '',
            'priority' => '10',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Home Page Top Section
         */
        $wp_customize->add_section('home_top_section', array(
            'title' => __('Top Heading Section', 'bizway'),
            'description' => __('Allows you to setup Top heading section for Bizway Theme.', 'bizway'), //Descriptive tooltip
            'panel' => '',
            'priority' => '11',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Add panel for home page Slider area
         */
        $wp_customize->add_panel('home_page_slider_panel', array(
            'title' => __('Home Page Slider', 'bizway'),
            'description' => __('Allows you to setup home page slider area section for Bizway Theme.', 'bizway'),
            'priority' => '13',
            'capability' => 'edit_theme_options'
        ));
        /**
         * Home Page Slider area 1
         */
        $wp_customize->add_section('home_slider_1', array(
            'title' => __('First Slider Setting', 'bizway'),
            'description' => __('Allows you to setup first slider for Bizway Theme.', 'bizway'),
            'panel' => 'home_page_slider_panel',
            'priority' => '',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Home Page Slider area 1
         */
        $wp_customize->add_section('home_slider_2', array(
            'title' => __('Second Slider Setting', 'bizway'),
            'description' => __('Allows you to setup second slider for Bizway Theme.', 'bizway'),
            'panel' => 'home_page_slider_panel',
            'priority' => '',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Add panel for home page feature area
         */
        $wp_customize->add_panel('home_feature_area_panel', array(
            'title' => __('Home Page Feature Area', 'bizway'),
            'description' => __('Allows you to setup home page feature area section for Bizway Theme.', 'bizway'),
            'priority' => '14',
            'capability' => 'edit_theme_options'
        ));
        /**
         * Home Page feature area 1
         */
        $wp_customize->add_section('home_feature_area_1', array(
            'title' => __('First Feature Area', 'bizway'),
            'description' => __('Allows you to setup first feature area section for Bizway Theme.', 'bizway'),
            'panel' => 'home_feature_area_panel',
            'priority' => '',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Home Page feature area 2
         */
        $wp_customize->add_section('home_feature_area_2', array(
            'title' => __('Second Feature Area', 'bizway'),
            'description' => __('Allows you to setup second feature area section for Bizway Theme.', 'bizway'),
            'panel' => 'home_feature_area_panel',
            'priority' => '',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Home Page feature area 3
         */
        $wp_customize->add_section('home_feature_area_3', array(
            'title' => __('Third Feature Area', 'bizway'),
            'description' => __('Allows you to setup third feature area section for Bizway Theme.', 'bizway'),
            'panel' => 'home_feature_area_panel',
            'priority' => '',
            'capability' => 'edit_theme_options'
                )
        );
        /**
         * Style Section
         */
        $wp_customize->add_section('style_section', array(
            'title' => __('Style Setting', 'bizway'),
            'description' => __('Allows you to change style using custom css for Bizway Theme.', 'bizway'),
            'panel' => '',
            'priority' => '15',
            'capability' => 'edit_theme_options'
                )
        );
          /**
         * Social Icons Section
         */
        $wp_customize->add_section('social_icon_settings', array(
            'title' => __('Social Icons', 'bizway'),
            'description' => __('Allows you to setup social site link for Bizway Theme.', 'bizway'),
            'panel' => '',
            'priority' => '14',
            'capability' => 'edit_theme_options'
                )
        );
    }
    public static function Bizway_Section_Content() {
        $section_content = array(
            'general_setting' => array(
                'bizway_logo',
                'bizway_favicon',
                'bizway_analytics'
            ),
            'home_top_section' => array(
                'bizway_first_head',
                'bizway_second_head',
                'bizway_slideimage1',
                'bizway_slidelink1',
                'bizway_slideimage2',
                'bizway_slidelink2'
            ),
            'home_slider_1' => array(
                'bizway_slideimage1',
                'bizway_slidelink1'
            ),
            'home_slider_2' => array(
                'bizway_slideimage2',
                'bizway_slidelink2'
            ),
            'home_feature_area_1' => array(
                'bizway_featureimg1',
                'bizway_firsthead',
                'bizway_firstdesc',
                'bizway_link1'
            ),
            'home_feature_area_2' => array(
                'bizway_featureimg2',
                'bizway_secondhead',
                'bizway_seconddesc',
                'bizway_link2'
            ),
            'home_feature_area_3' => array(
                'bizway_featureimg3',
                'bizway_thirdhead',
                'bizway_thirddesc',
                'bizway_link3'
            ),
            'style_section' => array(
                'bizway_customcss'
            ),
            'social_icon_settings' => array(
                'bizway_facebook',
                'bizway_twitter',
                'bizway_yahoo',
                'bizway_rss',
                'bizway_digg',
                'bizway_pinterest',
                'bizway_linkedin',
                'bizway_instagram',
                'bizway_google',
               'bizway_youtube',
               'bizway_tumblr',
               'bizway_flickr'
            ),

        );
        return $section_content;
    }
    public static function Bizway_Settings() {
        $bizway_settings = array(
            'bizway_logo' => array(
                'id' => 'bizway_options[bizway_logo]',
                'label' => __('Custom Logo', 'bizway'),
                'description' => __('Choose your own logo. Optimal Size: 300px Wide by 90px Height.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => get_template_directory_uri() . '/images/logo.png'
            ),
            'bizway_favicon' => array(
                'id' => 'bizway_options[bizway_favicon]',
                'label' => __('Custom Favicon', 'bizway'),
                'description' => __('Specify a 16px x 16px image that will represent your website&#039;s favicon.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => ''
            ),
            'bizway_analytics' => array(
                'id' => 'bizway_options[bizway_analytics]',
                'label' => __('Tracking Code', 'bizway'),
                'description' => __('Paste your Google Analytics (or other) tracking code here.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => ''
            ),
            'bizway_first_head' => array(
                'id' => 'bizway_options[bizway_first_head]',
                'label' => __('First Heading', 'bizway'),
                'description' => __('Enter your text for first heading.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Easy & Flexible to Use WordPress Theme', 'bizway')
            ),
            'bizway_second_head' => array(
                'id' => 'bizway_options[bizway_second_head]',
                'label' => __('Second Heading', 'bizway'),
                'description' => __('Enter your text for second heading.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('The header area consists of the area for putting up your own fullwidth banner which can add Address details.__', 'bizway')
            ),
            'bizway_slideimage1' => array(
                'id' => 'bizway_options[bizway_slideimage1]',
                'label' => __('First Slider Image', 'bizway'),
                'description' => __('Choose your image for first slider. Optimal size is 950px wide and 350px height.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => get_template_directory_uri() . '/images/slide1.jpg'
            ),
            'bizway_slidelink1' => array(
                'id' => 'bizway_options[bizway_slidelink1]',
                'label' => __('First Slide Link', 'bizway'),
                'description' => __('Enter your link url for first slide', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_slideimage2' => array(
                'id' => 'bizway_options[bizway_slideimage2]',
                'label' => __('Second Slider Image', 'bizway'),
                'description' => __('Choose your image for second slider. Optimal size is 950px wide and 350px height.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => get_template_directory_uri() . '/images/slide2.jpg'
            ),
            'bizway_slidelink2' => array(
                'id' => 'bizway_options[bizway_slidelink2]',
                'label' => __('Second Slide Link', 'bizway'),
                'description' => __('Enter your link url for second slide', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_featureimg1' => array(
                'id' => 'bizway_options[bizway_featureimg1]',
                'label' => __('First Feature Image', 'bizway'),
                'description' => __('Choose your image for first feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => get_template_directory_uri() . '/images/img1.png'
            ),
            'bizway_firsthead' => array(
                'id' => 'bizway_options[bizway_firsthead]',
                'label' => __('First Feature Heading', 'bizway'),
                'description' => __('Enter your text for first feature area heading.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Elegant & Simple', 'bizway')
            ),
            'bizway_firstdesc' => array(
                'id' => 'bizway_options[bizway_firstdesc]',
                'label' => __('First Feature Description', 'bizway'),
                'description' => __('Enter your text for first feature area description.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Slider in the Header. It comes different Color Schemes red, green, blue, brown, pink, black, orange. Hello this design comes.', 'bizway')
            ),
            'bizway_link1' => array(
                'id' => 'bizway_options[bizway_link1]',
                'label' => __('First feature Link', 'bizway'),
                'description' => __('Enter your link url for first feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_featureimg2' => array(
                'id' => 'bizway_options[bizway_featureimg2]',
                'label' => __('Second Feature Image', 'bizway'),
                'description' => __('Choose your image for second feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => get_template_directory_uri() . '/images/img2.png'
            ),
            'bizway_secondhead' => array(
                'id' => 'bizway_options[bizway_secondhead]',
                'label' => __('Second Feature Heading', 'bizway'),
                'description' => __('Enter your text for second feature area heading.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Beautiful & Responsive', 'bizway')
            ),
            'bizway_seconddesc' => array(
                'id' => 'bizway_options[bizway_seconddesc]',
                'label' => __('Second Feature Description', 'bizway'),
                'description' => __('Write short description for your second feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Slider in the Header. It comes different Color Schemes red, green, blue, brown, pink, black, orange. Hello this design comes.', 'bizway')
            ),
            'bizway_link2' => array(
                'id' => 'bizway_options[bizway_link2]',
                'label' => __('Second Feature Link', 'bizway'),
                'description' => __('Enter your link url for second feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_featureimg3' => array(
                'id' => 'bizway_options[bizway_featureimg3]',
                'label' => __('Third Feature Image', 'bizway'),
                'description' => __('Choose your image for Third feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'image',
                'default' => get_template_directory_uri() . '/images/img3.png'
            ),
            'bizway_thirdhead' => array(
                'id' => 'bizway_options[bizway_thirdhead]',
                'label' => __('Third Feature Heading', 'bizway'),
                'description' => __('Enter your text for second feature area heading.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Art & Creativity', 'bizway')
            ),
            'bizway_thirddesc' => array(
                'id' => 'bizway_options[bizway_thirddesc]',
                'label' => __('Third Feature Description', 'bizway'),
                'description' => __('Enter your text for Third feature area description.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => __('Slider in the Header. It comes different Color Schemes red, green, blue, brown, pink, black, orange. Hello this design comes.', 'bizway')
            ),
            'bizway_link3' => array(
                'id' => 'bizway_options[bizway_link3]',
                'label' => __('Third feature Link', 'bizway'),
                'description' => __('Enter your link url for third feature area.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_customcss' => array(
                'id' => 'bizway_options[bizway_customcss]',
                'label' => __('Custom CSS', 'bizway'),
                'description' => __('Quickly add your custom CSS code to your theme by writing the code in this block.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'textarea',
                'default' => ''
            ),
            'bizway_facebook' => array(
                'id' => 'bizway_options[bizway_facebook]',
                'label' => __('Facebook URL', 'bizway'),
                'description' => __('Enter your Facebook URL if you have one.', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_twitter' => array(
                'id' => 'bizway_options[bizway_twitter]',
                'label' => __('Twitter URL', 'bizway'),
                'description' => __('Enter your Twitter URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_yahoo' => array(
                'id' => 'bizway_options[bizway_yahoo]',
                'label' => __('Yahoo URL', 'bizway'),
                'description' => __('Enter your Yahoo Feed URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_rss' => array(
                'id' => 'bizway_options[bizway_rss]',
                'label' => __('Rss URL', 'bizway'),
                'description' => __('Enter your Rss URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_digg' => array(
                'id' => 'bizway_options[bizway_digg]',
                'label' => __('Digg URL', 'bizway'),
                'description' => __('Enter your Digg URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_pinterest' => array(
                'id' => 'bizway_options[bizway_pinterest]',
                'label' => __('Pinterest URL', 'bizway'),
                'description' => __('Enter your Pinterest URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_linkedin' => array(
                'id' => 'bizway_options[bizway_linkedin]',
                'label' => __('Linkedin URL', 'bizway'),
                'description' => __('Enter your Linkedin URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_google' => array(
                'id' => 'bizway_options[bizway_google]',
                'label' => __('Google URL', 'bizway'),
                'description' => __('Enter your Google URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_instagram' => array(
                'id' => 'bizway_options[bizway_instagram]',
                'label' => __('Instagram URL', 'bizway'),
                'description' => __('Enter your Instagram URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_youtube' => array(
                'id' => 'bizway_options[bizway_youtube]',
                'label' => __('Youtube URL', 'bizway'),
                'description' => __('Enter your Youtube URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_tumblr' => array(
                'id' => 'bizway_options[bizway_tumblr]',
                'label' => __('Tumblr URL', 'bizway'),
                'description' => __('Enter your Tumblr URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
            'bizway_flickr' => array(
                'id' => 'bizway_options[bizway_flickr]',
                'label' => __('Flickr URL', 'bizway'),
                'description' => __('Enter your Flickr URL if you have one', 'bizway'),
                'type' => 'option',
                'setting_type' => 'link',
                'default' => '#'
            ),
        );
        return $bizway_settings;
    }
    public static function Bizway_Controls($wp_customize) {
        $sections = self::Bizway_Section_Content();
        $settings = self::Bizway_Settings();
        foreach ($sections as $section_id => $section_content) {
            foreach ($section_content as $section_content_id) {
                switch ($settings[$section_content_id]['setting_type']) {
                    case 'image':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'bizway_sanitize_url');
                        $wp_customize->add_control(new WP_Customize_Image_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id']
                                )
                        ));
                        break;
                    case 'text':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'bizway_sanitize_text');
                        $wp_customize->add_control(new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'text'
                                )
                        ));
                        break;
                    case 'textarea':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'bizway_sanitize_textarea');
                        $wp_customize->add_control(new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'textarea'
                                )
                        ));
                        break;
                    case 'link':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'bizway_sanitize_url');
                        $wp_customize->add_control(new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'text'
                                )
                        ));
                        break;
                    default:
                        break;
                }
            }
        }
    }
    public static function add_setting($wp_customize, $setting_id, $default, $type, $sanitize_callback) {
        $wp_customize->add_setting($setting_id, array(
            'default' => $default,
            'capability' => 'edit_theme_options',
            'sanitize_callback' => array('Bizway_Customizer', $sanitize_callback),
            'type' => $type
                )
        );
    }
    /**
     * adds sanitization callback funtion : textarea
     * @package Bizway
     */
    public static function bizway_sanitize_textarea($value) {
       $allowedtags = array(
            'iframe' => array(
                'width' => array(),
                'height' => array(),
                'frameborder' => array(),
                'src' => array(),
                'marginwidth' => array(),
                'marginheight' => array(),
            ),
            wp_kses_allowed_html()
        );
        $array = wp_kses_allowed_html('post');
        $allowedtags = array(
            'iframe' => array(
                'width' => array(),
                'height' => array(),
                'frameborder' => array(),
                'src' => array(),
                'marginwidth' => array(),
                'marginheight' => array(),
            )
        );
        $data = array_merge($allowedtags, $array);
        $value = wp_kses($value, $data);
        return $value;
    }
    /**
     * adds sanitization callback funtion : url
     * @package Bizway
     */
    public static function bizway_sanitize_url($value) {
        $value = esc_url($value);
        return $value;
    }
    /**
     * adds sanitization callback funtion : text
     * @package Bizway
     */
    public static function bizway_sanitize_text($value) {
        $value = sanitize_text_field($value);
        return $value;
    }
    /**
     * adds sanitization callback funtion : email
     * @package Bizway
     */
    public static function bizway_sanitize_email($value) {
        $value = sanitize_email($value);
        return $value;
    }
    /**
     * adds sanitization callback funtion : number
     * @package Bizway
     */
    public static function bizway_sanitize_number($value) {
        $value = preg_replace("/[^0-9+ ]/", "", $value);
        return $value;
    }
}
// Setup the Theme Customizer settings and controls...
add_action('customize_register', array('Bizway_Customizer', 'Bizway_Register'));
function inkthemes_registers() {
          wp_register_script( 'inkthemes_jquery_ui', '//code.jquery.com/ui/1.11.0/jquery-ui.js', array("jquery"), true  );
	wp_register_script( 'inkthemes_customizer_script', get_template_directory_uri() . '/js/inkthemes_customizer.js', array("jquery","inkthemes_jquery_ui"), true  );
	wp_enqueue_script( 'inkthemes_customizer_script' );
	wp_localize_script( 'inkthemes_customizer_script', 'ink_advert', array(
		'pro' => __('View PRO version','bizway'),
		'url' => esc_url('https://www.inkthemes.com/market/simple-wordpress-theme/'),
		'support_text' => __('Need Help!','bizway'),
		'support_url' => esc_url('https://www.inkthemes.com/contact-us/')
	) );
}
add_action( 'customize_controls_enqueue_scripts', 'inkthemes_registers' );