<?php
/**
 * The template for displaying the footer.
 *
 *
 * @package Bizway
 * @since Bizway 1.0
 */
?>

<!--Start Footer Wrapper-->
<div class="footer-wrapper">
    <!--Start Wrapper-->
    <div class="container_24">
        <div class="grid_24">
            <div class="footer">
                <?php
                /* A sidebar in the footer? Yep. You can can customize
                 * your footer with four columns of widgets.
                 */
                get_sidebar('footer');
                ?>
            </div>
        </div>
        <div class="clear"></div>
    </div>
</div>
<!--End Wrapper-->
<!--End Footer Wrapper-->
<!--Start Footer Bottom-->
<div class="footer_bottom">
    <!--Start Wrapper-->
    <div class="wrapper">
        <div class="container_24">
            <div class="grid_24">
                <div class="footer_bottom_content">
                
                    <p class="theme_desc"><?php echo get_bloginfo('title'); ?>-<?php echo get_bloginfo('description'); ?></p>
                    <?php if (bizway_get_option('bizway_footertext') != '') { ?>
                        <p class="copyright"><?php echo esc_attr(bizway_get_option('bizway_footertext')); ?></p> 
                    <?php } else { ?>
                        <p class="copyright"> <a rel="nofollow" href="<?php esc_url("https://www.inkthemes.com/market/simple-wordpress-theme/"); ?>"><?php _e('BizWay Theme', 'bizway'); ?></a><?php _e(' powered by ', 'bizway'); ?><a href="http://www.wordpress.org"><?php _e('WordPress', 'bizway'); ?></a></p>
                            <?php } ?>
                </div>
                <ul class="social_logos">
                        <?php if (bizway_get_option('bizway_facebook') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_facebook')); ?>" title="Facebook">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/facebook.png" alt="Facebook" />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_twitter') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_twitter')); ?>" title="Twitter">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/twitter.png" alt="Twitter" />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_yahoo') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_yahoo')); ?>" title="Yahoo">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/yahoo.png" alt="Yahoo" />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_rss') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_rss')); ?>" title="Rss Feed">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/rss.png" alt="Digg Icon" />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_digg') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_digg')); ?>" title="Digg">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/digg.png" alt="Digg icon" />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_pinterest') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_pinterest')); ?>" title="Pinterest">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/pinterest.png" alt="Pinterest icon"
                                />
                            </a>
                        </li>
                        <?php } ?> 
                        <?php if (bizway_get_option('bizway_linkedin') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_linkedin')); ?>" title="Pinterest">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/in.png" alt="Linkedin icon"
                                />
                            </a>
                        </li>
                        <?php } ?> 
                        <?php if (bizway_get_option('bizway_instagram') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_instagram')); ?>" title="Instagram">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/instagram.png" alt="Instagram icon"
                                />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_google') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_google')); ?>" title="Google">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/g+.png" alt="Google icon"
                                />
                            </a>
                        </li>
                        <?php } ?> 
                        <?php if (bizway_get_option('bizway_youtube') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_youtube')); ?>" title="Youtube">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/youtube.png" alt="Youtube icon"
                                />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_tumblr') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_tumblr')); ?>" title="Tumblr">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/tumblr.png" alt="Tumblr icon"
                                />
                            </a>
                        </li>
                        <?php } ?>
                        <?php if (bizway_get_option('bizway_flickr') != '') { ?>
                        <li>
                            <a href="<?php echo esc_url(bizway_get_option('bizway_flickr')); ?>" title="Flickr">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/flickr.png" alt="Flickr icon"
                                />
                            </a>
                        </li>
                        <?php } ?>
            </ul>
            </div>
        </div>
    </div>
    <!--End Wrapper-->
</div>
<!--End Footer Bottom-->
<?php wp_footer(); ?>
</body>
</html>