<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package
 */
?>

<div class="blog_post mb-4">
    <div class="post_img">
        <?php biznol_post_thumbnail(); ?>
    </div>
    <div id="post-<?php the_ID(); ?>" <?php post_class('post_content'); ?>>
        <?php if (get_theme_mod('date_meta_display', true) || get_theme_mod('author_meta_display', true) || get_theme_mod('cat_meta_display', true))  ?>
        <div class="post_meta mt-2">
            <!-- Meta Date -->
            <?php if (get_theme_mod('date_meta_display', true)) { ?>
                <span class="date"><a href="<?php echo esc_url(get_month_link(get_post_time('Y'), get_post_time('m'))); ?>"><time><?php echo esc_html(get_the_date()); ?></time></a></span>
            <?php } ?>

            <!-- Meta Author -->
            <?php if (get_theme_mod('author_meta_display', true)) { ?>
                <span class="author"><?php esc_html_e('By', 'biznol'); ?> <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo esc_html(get_the_author()); ?></a></span>
            <?php } ?>

            <!-- Meta Category-->
            <?php if (get_theme_mod('cat_meta_display', true)) { ?>
                <span class="categories">
                    <?php
                    $biznol_cats = get_the_category_list();
                    if (!empty($biznol_cats)) {
                        ?>
                        <?php the_category(' '); ?>
                    <?php } ?>
                </span>
            <?php } ?>

        </div>



        <?php
        if (is_singular()) :
            the_title('<h4 class="entry-title">', '</h4>');
        else :
            the_title('<h4 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h4>');
        endif;
        ?><p><?php
            /*
             * Content may be excerpt or content as defined by settings
             */
            if (is_singular()) {
                the_content();
            } else {
                if (function_exists('biznol_ExcerptOrContent'))
                    biznol_ExcerptOrContent();
            }
            ?></p>
    </div>
</div>