<?php

function biznol_gen_customizer_setting($wp_customize) {

    $wp_customize->add_panel(
            'biznol_gen_setting',
            [
                'priority' => 30,
                'capability' => 'edit_theme_options',
                'title' => __('General', 'biznol'),
            ]
    );

    /* Blog Section */
    $wp_customize->add_section(
            'biznol_general_blog_Section',
            [
                'priority' => 1,
                'title' => __('Blogs', 'biznol'),
                'panel' => 'biznol_gen_setting',
            ]
    );

    /* Color Section */
    $wp_customize->add_section(
            'colors',
            [
                'priority' => 1,
                'title' => __('Colors', 'biznol'),
                'panel' => 'biznol_gen_setting',
            ]
    );

    $wp_customize->get_setting('background_color')->default = '#f0f0f1';

    $wp_customize->add_setting('biznol_excerpt_or_content',
            [
                'default' => esc_html__('excerpt', 'biznol'),
                'sanitize_callback' => 'biznol_sanitize_select'
            ]
    );

    $wp_customize->add_control('biznol_excerpt_or_content',
            [
                'label' => esc_html__('Choose Options', 'biznol'),
                'section' => 'biznol_general_blog_Section',
                'type' => 'radio',
                'choices' => [
                    'excerpt' => esc_html__('Excerpt', 'biznol'),
                    'content' => esc_html__('Content', 'biznol'),
                ]
            ]
    );

    $wp_customize->add_setting('biznol_characters_option_length', [
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'biznol_sanitize_select',
        'default' => 'custom',
    ]);

    $wp_customize->add_control('biznol_characters_option_length', [
        'type' => 'select',
        'section' => 'biznol_general_blog_Section', // Add a default or your own section
        'label' => __('Characters length', 'biznol'),
        'description' => __('Recommended to use custom lenght of 35. This character length will also be applied to blog section of the homepage template.', 'biznol'),
        'choices' => [
            'default' => __('Default', 'biznol'),
            'custom' => __('Custom', 'biznol'),
        ],
    ]);

    $wp_customize->add_setting('biznol_characters_length',
            [
                'default' => 35,
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'absint',
            ]
    );
    $wp_customize->add_control('biznol_characters_length',
            [
                'label' => esc_html__('Length', 'biznol'),
                'section' => 'biznol_general_blog_Section',
                'active_callback' => 'biznol_for_custom_len',
                'input_attrs' => ['min' => 10, 'max' => 250, 'step' => 1],
                'type' => 'number',
            ]
    );

//    date
    $wp_customize->add_setting('date_meta_display',
            [
                'default' => true,
                'sanitize_callback' => 'biznol_switch_sanitization'
            ]
    );
    $wp_customize->add_control(new Biznol_Toggle_Switch_Custom_Control($wp_customize, 'date_meta_display',
                    [
                'label' => __('Date', 'biznol'),
                'section' => 'biznol_general_blog_Section'
                    ]
    ));

//    author
    $wp_customize->add_setting('author_meta_display',
            [
                'default' => true,
                'sanitize_callback' => 'biznol_switch_sanitization'
            ]
    );
    $wp_customize->add_control(new Biznol_Toggle_Switch_Custom_Control($wp_customize, 'author_meta_display',
                    [
                'label' => __('Author', 'biznol'),
                'section' => 'biznol_general_blog_Section'
                    ]
    ));

//    category
    $wp_customize->add_setting('cat_meta_display',
            [
                'default' => true,
                'sanitize_callback' => 'biznol_switch_sanitization'
            ]
    );
    $wp_customize->add_control(new Biznol_Toggle_Switch_Custom_Control($wp_customize, 'cat_meta_display',
                    [
                'label' => __('Category', 'biznol'),
                'section' => 'biznol_general_blog_Section'
                    ]
    ));

    //Button: Read More
    $wp_customize->add_setting('biznol_readmore_button_txt', [
        'capability' => 'edit_theme_options',
        'default' => 'Read More',
        'sanitize_callback' => 'sanitize_text_field',
    ]);

    $wp_customize->add_control('biznol_readmore_button_txt', [
        'type' => 'text',
        'section' => 'biznol_general_blog_Section', // Add a default or your own section
        'label' => __('Button Text', 'biznol'),
        'description' => __('This button text will also be applied to blog section of the homepage template', 'biznol'),
    ]);

    if (!function_exists('biznol_for_custom_len')) {

        function biznol_for_custom_len($control) {
            if ($control->manager->get_setting('biznol_characters_option_length')->value() == 'custom') {
                return true;
            }
            return false;
        }

    }

    if (!function_exists('biznol_switch_sanitization')) {

        function biznol_switch_sanitization($input) {
            if (true === $input) {
                return 1;
            } else {
                return 0;
            }
        }

    }

    if (!function_exists('biznol_sanitize_select')) {

        function biznol_sanitize_select($input, $setting) {
            $input = sanitize_key($input);
            $choices = $setting->manager->get_control($setting->id)->choices;
            return ( array_key_exists($input, $choices) ? $input : $setting->default );
        }

    }
}

add_action('customize_register', 'biznol_gen_customizer_setting');
