<?php

function biznol_customizer_breadcrumb($wp_customize) {
    $wp_customize->add_section(
            'biznol_breadcrumb_setting',
            array(
                'title' => esc_html__('Archive page title', 'biznol'),
                'description' => esc_html__('Here you can set the prefix to the breadcrumb title for all Archive pages or can leave empty', 'biznol'),
            )
    );

    $wp_customize->add_setting(
            'biznol_archive_prefix',
            array(
                'default' => esc_html__('Archive:', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_archive_prefix', array(
        'label' => esc_html__('Archive', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));

    $wp_customize->add_setting(
            'biznol_category_prefix',
            array(
                'default' => esc_html__('Category:', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_category_prefix', array(
        'label' => esc_html__('Category', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));

    $wp_customize->add_setting(
            'biznol_tag_prefix',
            array(
                'default' => esc_html__('Tag:', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_tag_prefix', array(
        'label' => esc_html__('Tag', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));

    $wp_customize->add_setting(
            'biznol_author_prefix',
            array(
                'default' => esc_html__('All posts by:', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_author_prefix', array(
        'label' => esc_html__('Author', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));

    $wp_customize->add_setting(
            'biznol_search_prefix',
            array(
                'default' => esc_html__('Search results for:', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_search_prefix', array(
        'label' => esc_html__('Search', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));

    $wp_customize->add_setting(
            'biznol_404_prefix',
            array(
                'default' => esc_html__('404: Page not found', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_404_prefix', array(
        'label' => esc_html__('404', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));

    $wp_customize->add_setting(
            'biznol_shop_prefix',
            array(
                'default' => esc_html__('Shop', 'biznol'),
                'capability' => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            )
    );
    $wp_customize->add_control('biznol_shop_prefix', array(
        'label' => esc_html__('Shop', 'biznol'),
        'section' => 'biznol_breadcrumb_setting',
        'type' => 'text'
    ));
}

add_action('customize_register', 'biznol_customizer_breadcrumb');
