<?php
/**
 *
 * This file to add more information about Biznol.
 *
 * @package Biznol
 *
 *  Class to add more information about biznol
 *
 *  @param WP_Customize_Manager $wp_customize    Manager instance.
 */

if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return;
}

if ( ! class_exists( 'Biznol_Pro_Info_Control' ) ) {

	class Biznol_Pro_Info_Control extends WP_Customize_Control {

		public $type = 'upgrade_premium';

		function render_content() {
			?>
			<div class="upgrade_ubt_info">
				<ul>
					<li><a class="documentation" href="<?php echo esc_url('https://docs.unibirdtech.com/') ?>" target="_blank"><span class="dashicons dashicons-search"></span>&ensp;<?php esc_html_e( 'Documentation', 'biznol' ); ?> </a></li>
					<li><a class="our-support" href="<?php echo esc_url('https://unibirdtech.com/submit-ticket/'); ?>" target="_blank"><span class="dashicons dashicons-editor-help"></span>&ensp;<?php esc_html_e( 'Satisfactory Support', 'biznol' ); ?> </a></li>
					<li><a class="free-v-pro" href="<?php echo esc_url('https://unibirdtech.com/themes/biznol-pro/'); ?>" target="_blank"><span class="dashicons dashicons-visibility"></span>&ensp;<?php esc_html_e( 'Free Vs Pro Features', 'biznol' ); ?> </a></li>
					<li><a class="upgrade-to-pro" href="<?php echo esc_url('https://unibirdtech.com/themes/biznol-pro/'); ?>" target="_blank"><span class="dashicons dashicons-update"></span>&ensp;<?php esc_html_e( 'Upgrade to Pro', 'biznol' ); ?> </a></li>
					<li><a class="nice-feedback" href="<?php echo esc_url('https://wordpress.org/support/theme/biznol/reviews/#new-post'); ?>" target="_blank"><span class="dashicons dashicons-smiley"></span>&ensp;<?php esc_html_e( 'Share a Nice Review', 'biznol' ); ?> </a></li>
				</ul>
			</div>
				<?php
		}

	}

}