<?php

/**
 * Handles front end setup.
 *
 * @package Biznol
 */

/**
 * Class Biznol_public
 */
class Biznol_public {

	/* Scripts Load */

	public function corposet_scripts_function() {
		 /**
		  * Styles
		  */
		wp_enqueue_style( 'biznol-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css', array(), wp_get_theme()->get( 'Version' ) );
		wp_enqueue_style( 'biznol-skin', get_template_directory_uri() . '/assets/css/skin/theme-default.css', array(), wp_get_theme()->get( 'Version' ) );
		wp_enqueue_style( 'biznol-style', get_stylesheet_uri() );
		wp_style_add_data( 'biznol_style', 'rtl', 'replace' );
		wp_enqueue_style( 'smartmenus', get_template_directory_uri() . '/assets/css/bootstrap-smartmenus.css', array(), wp_get_theme()->get( 'Version' ) );
		wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css', array(), wp_get_theme()->get( 'Version' ) );
		wp_enqueue_style( 'biznol-animate', get_template_directory_uri() . '/assets/css/animate.css', array(), wp_get_theme()->get( 'Version' ) );
		wp_enqueue_style( 'biznol-owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.css', array(), wp_get_theme()->get( 'Version' ) );
		$is_assigned = has_nav_menu( 'primary' );
		if ( ! is_user_logged_in() && ! $is_assigned ) {
			$menu_not_exist = '.navbar.navbar-expand-md{display:none}';
			wp_add_inline_style( 'biznol-style', $menu_not_exist );
		}
		wp_enqueue_style( 'biznol-style-base', get_template_directory_uri() . '/assets/css/style-base.css', array(), wp_get_theme()->get( 'Version' ) );

		/**
		 * Scripts
		 */
		wp_enqueue_script( 'biznol-bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'biznol-owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'smartmenus-js', get_template_directory_uri() . '/assets/js/jquery.smartmenus.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'smartmenus-bootstrap', get_template_directory_uri() . '/assets/js/jquery.smartmenus.bootstrap.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'biznol-main', get_template_directory_uri() . '/assets/js/main.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'biznol-wow', get_template_directory_uri() . '/assets/js/wow.js', array( 'jquery' ), '', true );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}

	/**
	 * Register widgets for the theme.
	 */

	public function initialize_widgets() {

		register_sidebar([
			'name' => esc_html__('Sidebar Area', 'biznol'),
			'id' => 'sidebar-1',
			'before_widget' => '<div id="%1$s" class="widget biznol-widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h3>',
			'after_title' => '</h3>',
		]);
	
		register_sidebar([
			'name' => esc_html__('Footer Area', 'biznol'),
			'id' => 'footer_widget_area',
			'before_widget' => '<div class="col-md-3"><div id="%1$s" class="widget biznol-widget %2$s">',
			'after_widget' => '</div></div>',
			'before_title' => '<h4 class="widget-title widget-title-1">',
			'after_title' => '</h4>',
		]);
	
		register_sidebar([
			'name' => esc_html__('WooCommerce Sidebar Area', 'biznol'),
			'id' => 'woocommerce',
			'description' => esc_html__('Drap and drop WooCommerce widgets here', 'biznol'),
			'before_widget' => '<div id="%1$s" class="widget biznol-widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h3>',
			'after_title' => '</h3>',
		]);
	
		register_sidebar([
			'name' => esc_html__('Header Area', 'biznol'),
			'id' => 'header_callout_area',
			'description' => esc_html__('Drap and drop Header Callout widgets here', 'biznol'),
			'before_widget' => '<div class="col-md-3"><div id="%1$s" class="widget biznol-widget %2$s">',
			'after_widget' => '</div></div>',
		]);
	}

	/**
	 * Setup the theme.
	 *
	 * @since Biznol 1.0
	 */
	public function setup_theme() {
		// Maximum allowed width for any content in the theme, like oEmbeds and images added to posts.  https://codex.wordpress.org/Content_Width

		$GLOBALS['content_width'] = apply_filters( 'biznol_content_width', 640 );

		$logo_settings = array(
			'height'      => 55,
			'width'       => 150,
			'flex-height' => true,
			'flex-width'  => true,
		);

		$custom_background_settings = array(
			'default-color' => apply_filters( 'biznol_default_background_color', 'E5E5E5' ),
		);

		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'custom-logo', $logo_settings );
		add_theme_support( 'html5', array( 'search-form' ) );
		add_theme_support( 'custom-background', $custom_background_settings );
		add_theme_support( 'header-footer-elementor' );

		// woocommerce support

		add_theme_support( 'woocommerce' );

		// Woocommerce Gallery Support
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );

		load_theme_textdomain( 'biznol', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => __( 'Primary Menu', 'biznol' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'biznol_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		add_editor_style();
	}

}

// Enqueue For Admin css and js
function biznol_admin_enqueue_scripts() {
	wp_enqueue_style( 'biznol-admin-style', get_template_directory_uri() . '/assets/css/admin.css' );
	wp_enqueue_script( 'biznol-admin-script', get_template_directory_uri() . '/assets/js/biznol-admin-script.js', array( 'jquery' ), '', true );
	wp_localize_script(
		'biznol-admin-script',
		'biznol_ajax_object',
		array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
	);
}

add_action( 'admin_enqueue_scripts', 'biznol_admin_enqueue_scripts' );

function biznol_menu() {
	?>
	<script>
		jQuery('a,input').bind('focus', function () {
			if (!jQuery(this).closest(".menu-item").length && (jQuery(window).width() <= 992)) {
				jQuery('.navbar-collapse').removeClass('show');
			}
		})
	</script>
	<?php

}

add_action( 'wp_footer', 'biznol_menu' );
