<?php
/**
 * The header file of the theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="https://gmpg.org/xfn/11">

		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>
		<?php wp_body_open(); ?>
		<div id="page" class="wrapper">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'biznol' ); ?></a>
			<!--header-->
			<header class="trasparent">

				<!--topbar-->
				<?php do_action( 'biznol_header_layouts' ); ?>

				<!--/topbar-->

				<!-- middel-header -->
				<div class="middel">
					<div class="container position-relative">
						<div class="row">
							<div class="col-md-3">
								<div class="left-work">
									<?php
									if ( has_custom_logo() ) {
										the_custom_logo();
									}
									?>

									<?php
									if ( display_header_text() === true ) {
										?>
										<div class="site-branding-text">
											<h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
											<p class="site-description"><?php bloginfo( 'description' ); ?></p>
										</div>
									<?php } ?>

								</div>
							</div>
							<?php
							if ( is_active_sidebar( 'header_callout_area' ) ) {
								dynamic_sidebar( 'header_callout_area' );
							} elseif ( current_user_can( 'edit_theme_options' ) ) {
								{
								?>
									<div class="col-md-9 d-flex justify-content-center text-center border" style="line-height: 3">
										<a data-customizer-event="biznol-header-sidebar-event" id="biznol-header-widget" class="text-muted" href='<?php echo esc_url( admin_url( 'widgets.php' ) ); ?>'><i class="fa fa-hand-pointer-o" aria-hidden="true"></i>
											<?php esc_html_e( 'Biznol: Header Callout widget', 'biznol' ); ?>
										</a>
									</div>
									<?php
									}
							}
							?>
						</div>
					</div>
				</div>
				<div class="nav_bg">
				<nav class="navbar navbar-expand-md nav-light">
					<div class="container position-relative">
						<div class="d-block d-lg-none">
									<?php
									if ( has_custom_logo() ) {
										the_custom_logo();
									}
									?>
									</div>
							<button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
								<span class="navbar-toggler-icon"><i class="fa fa-bars"></i></span>
							</button> 
							<?php
							wp_nav_menu(
								array(
									'theme_location'  => 'primary',
									'container'       => 'div',
									'container_class' => 'collapse navbar-collapse',
									'container_id'    => 'navbarCollapse',
									'menu_class'      => 'navbar-nav nav mx-auto',
									'fallback_cb'     => 'biznol_nav_walker::fallback',
									'walker'          => new biznol_nav_walker(),
								)
							);
							?>
					</div>
					</nav>
				</div>
			</header>
