<?php

/**
 * Biznol functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 */
define('BIZNOL_URI', trailingslashit(get_template_directory_uri('/')));
define('BIZNOL_DIR', trailingslashit(get_template_directory('/')));
define('BIZNOL_INCLUDE', trailingslashit(get_template_directory()) . 'inc/');
define('BIZNOL_BASE_DIR', BIZNOL_INCLUDE . 'core/');

require  BIZNOL_BASE_DIR . "class-biznol-public.php";
require BIZNOL_BASE_DIR . "class-biznol-admin.php";
require BIZNOL_INCLUDE . "customizer/class-biznol-pro-info-control.php";

$biznol_front = new Biznol_public();
add_action('wp_enqueue_scripts', array($biznol_front, 'corposet_scripts_function'));
add_action('after_setup_theme', array($biznol_front, 'setup_theme'));
add_action('widgets_init', array($biznol_front, 'initialize_widgets'));

$biznol_admin = new Biznol_Admin();
add_action( 'customize_register', array( $biznol_admin, 'biznol_pro_info' ) );
add_action( 'customize_preview_init', array($biznol_admin, 'biznol_preview_register') );
add_action( 'customize_controls_print_scripts', array($biznol_admin, 'shapro_theme_customizer') );

require get_template_directory() . '/inc/custom-header.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Header Widget WordPress.
 */
require get_template_directory() . '/inc/widget/biznol-header-callout-widget.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require_once get_template_directory() . '/inc/plugin-install.php';

/* Header */
require get_template_directory() . '/inc/customizer/customizer_header.php';

/* Footer */
require get_template_directory() . '/inc/customizer/customizer-footer.php';

/* Recommended plugin */
require get_template_directory() . '/inc/customizer/customizer_recommended_plugin.php';

/* Toggle */
require get_template_directory() . '/inc/customizer/customizer_toggle.php';

/* Header */
require get_template_directory() . '/inc/customizer/customizer_general.php';

/*
 * Breadcrumb
 */
require get_template_directory() . '/inc/customizer/customizer_breadcrumb.php';

require_once get_template_directory() . '/inc/class-biznol-bootstrap-navwalker.php';

/*-----Register Google Fonts--------*/

function biznol_fonts_url() {
    
    $fonts_url = '';
        
    $font_families = array();
 
    $font_families = array('Montserrat:400,500,700,800|Poppins:300,400,500,600,700,800,900&display=swap');
 
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );

    return $fonts_url;
}
function biznol_scripts_styles() {
    wp_enqueue_style( 'biznol-fonts', biznol_fonts_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'biznol_scripts_styles' );

/**
 * @todo remove
 */
add_action( "customize_register", "shapro_temp_remove_setting" ,99);
function shapro_temp_remove_setting( $wp_customize ) {

 $wp_customize->remove_control("top_phone_icon");
 $wp_customize->remove_control("top_header_phone_text");

}