<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Biznol
 */
?>
<!--footer-->
<footer class="wow fadeInUpBig" data-wow-delay="0ms" data-wow-duration="1500ms">
    <div class="container">
        <div class="top">
            <div class="row">
                <?php if (is_active_sidebar('footer_widget_area')) { ?>
                    <?php dynamic_sidebar('footer_widget_area'); ?>
                <?php } elseif (current_user_can('edit_theme_options')) { {
                        ?>
                        <div class="row d-flex justify-content-center text-center">
                            <p><a data-customizer-event="biznol-footer-sidebar-event" id="biznol-footer-widget-to-add" class="m-auto" href='<?php echo esc_url(admin_url('widgets.php')); ?>'><i class="fa fa-hand-pointer-o" aria-hidden="true"></i>
                                <?php esc_html_e('Click to assign widgets here.', 'biznol'); ?>
                            </a><p>
                        </div>
                        <?php
                    }
                }elseif (!is_user_logged_in()){
		add_action('wp_footer',function(){echo "<style type='text/css'>footer .top{padding-bottom: 0;}footer{padding-top: 0;}</style>";});
		    }
                ?>
            </div>
        </div>
        <?php
        if(get_theme_mod('copyright_display', 1)) {
        ?>
        <div class="bottom">
            <div class="row">
                <div class="col-md-12">
                    <div class="copyright-text">
                        <h4>
                        <?php
                            /* translators: 1: theme name, 2: theme url. */
                            $biznol_defaultCopyRight = get_theme_mod('copyright_text', sprintf( esc_html__( 'Theme: %1$s by %2$s', 'biznol' ), 'Biznol', '<a href="https://unibirdtech.com/">Unibird Tech</a>' ));
                            echo wp_kses_post($biznol_defaultCopyRight);
                        ?>
                        </h4>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</footer>
</div><!-- #page -->
<?php wp_footer(); ?>
</body>
</html>
