<?php 
/**
 * Template part for displaying related posts
 *
 * @package Medica
 */
$related_posts = bizindustries_related_posts(); 
$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable' ) ? 'animate-box':''; 
if ( $related_posts->have_posts() ): ?>

	<div class="related-posts clearfix">

		<?php 
		$related_title = get_theme_mod( 'related_posts_label', __( 'You May Also Like...', 'bizindustries' ) ); 
		if($related_title) : ?>
		<div class="related-heading <?php echo esc_attr($bizindustries_animation);?>">
			<h4><?php echo esc_html( $related_title ); ?></h4>
		</div>
		<?php endif; ?>
		
		<div class="row">
			<?php 

			while ( $related_posts->have_posts() ) : $related_posts->the_post();

			$blog_single_layout = get_theme_mod( 'blog_single_layout', 'right-sidebar' );
			if( $blog_single_layout == 'left-sidebar' || $blog_single_layout == 'right-sidebar' ) :
				$content_class = 'col-md-6 col-lg-6';
			else :
				$content_class = 'col-md-4 col-lg-4';
			endif;

			?>

			<div class="col-sm-12 <?php echo esc_attr( $content_class ); ?> <?php echo esc_attr($bizindustries_animation);?>"> 
				<div class="single-news <?php if( has_post_thumbnail() && true == get_theme_mod('post_thumbnail_display', true) ){ ?>has-thumbanil <?php } echo esc_attr($bizindustries_animation);?>">

					<?php 
					if( get_theme_mod('post_thumbnail_display', true) ) {
						bizindustries_post_thumbnail();
					}
					?>

					<div class="entry-header-wrap">
						<div class="entry-header <?php if( get_theme_mod('post_date_display', true) == false){ ?>no-date<?php }?>"> 
							<?php
								the_title( '<h4><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
								
								bizindustries_get_post_meta();
							?>

						</div>
						<?php
							if( get_theme_mod('post_date_display', true) ) {
								bizindustries_posted_on();
							}
						?>
					</div>

					<div class="entry-content"> 
						<?php
							if( get_theme_mod('post_content_display', true) ) {
								the_excerpt();
							} 
							if( get_theme_mod('post_readmore_display', true) ) {
								do_action('bizindustries_read_more_text');
							} 
							wp_link_pages( array(
								'before' => '<div class="page-links">' . __( 'Pages:', 'bizindustries' ),
								'after'  => '</div>',
							) );
						?>
					</div>

				</div>
			</div>

			<?php
			endwhile;
			wp_reset_postdata();
			?>

		</div>

	</div>
<?php endif; ?>