<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bizindustries
 */
$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':''; 
$post_cols = get_theme_mod( 'blog_columns', 'two-columns' );

if( $post_cols == 'two-columns' ) :
	$col_class = 'col-sm-12 col-md-6 col-lg-6';
elseif( $post_cols == 'three-columns' ) :
	$col_class = 'col-sm-6 col-md-4 col-lg-4';
else :
	$col_class = 'col-sm-12 col-md-12';
endif;

?>
<div class="masonry-item <?php echo esc_attr( $col_class ); ?>"> 
	<article id="post-<?php the_ID(); ?>">
		<!-- Start Single News -->
		<div class="single-news <?php if( has_post_thumbnail() && true == get_theme_mod('post_thumbnail_display', true) ){ ?>has-thumbanil <?php } echo esc_attr($bizindustries_animation);?>">
			
			<!-- Start Entry Thumb -->
			<?php 
			if( get_theme_mod('post_thumbnail_display', true) ) {
				bizindustries_post_thumbnail();
			}
			?>
			<!-- End Entry Thumb -->
			
			<!-- Start Entry Header -->
			<div class="entry-header-wrap">
				<div class="entry-header <?php if( get_theme_mod('post_date_display', true) == false ){ ?>no-date<?php }?>"> 
					<?php
						the_title( '<h4><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
						
						bizindustries_get_post_meta();
					?>

				</div>
				<?php
					if( get_theme_mod('post_date_display', true) ) {
						bizindustries_posted_on();
					}
				?>
			</div>
			<!-- End Post Header -->
			
			<!-- Start Entry Content -->
			<div class="entry-content"> 
				<?php
					if( get_theme_mod('post_content_display', true) ) {
						the_excerpt();
					} 
					if( get_theme_mod('post_readmore_display', true) ) {
						do_action('bizindustries_read_more_text');
					} 
					wp_link_pages( array(
						'before' => '<div class="page-links">' . __( 'Pages:', 'bizindustries' ),
						'after'  => '</div>',
					) );
				?>
			</div>
			<!-- End Post Content -->
		</div>
		<!-- End Single News -->
		
	</article>
</div>