<?php
/**
 *  Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bizindustries
 */
$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable' ) ? 'animate-box':''; 
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class('post-detail'); ?>>
		<!-- Start Single News -->
		<div class="single-news <?php if(has_post_thumbnail() && get_theme_mod('single_post_thumb_display', true) == true ){ ?>has-thumbanil <?php } echo esc_attr($bizindustries_animation);?>">
			
			<!-- Start Entry Thumb -->
			<?php
			if( get_theme_mod('single_post_thumb_display', 1) ) {
				bizindustries_post_thumbnail();
			}
			?>
			<!-- End Entry Thumb -->
			
			<!-- Start Entry Header -->
			<div class="entry-header-wrap">
				<div class="entry-header <?php if( get_theme_mod('single_post_date_display', true) == false ){ ?>no-date<?php }?>"> 
					
					<?php 
						the_title('<h3 class="entry-title">', '</h3>'); 
						
						if( get_theme_mod('single_post_meta_display', true) ) {
							bizindustries_get_post_meta();
						}
					?>

				</div>
				<?php
					if( get_theme_mod('single_post_date_display', true) ) {
						bizindustries_posted_on();
					}
				?>
			</div>
			<!-- End Post Header -->
			<!-- Start Entry Content -->
			<div class="entry-content"> 
				<?php
					the_content(
						sprintf(
							wp_kses(
								/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Read More<span class="screen-reader-text"> "%s"</span>', 'bizindustries' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							wp_kses_post( get_the_title() )
						)
					);
					
					wp_link_pages( array(
						'before' => '<div class="page-links">' . __( 'Pages:', 'bizindustries' ),
						'after'  => '</div>',
					) );
				?>
			</div>
			<!-- End Post Content -->
		</div>
		<!-- End Single News -->
		
	</article>