<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bizindustries
 */
$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable' ) ? 'animate-box':''; 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('col-sm-12 col-md-6'); ?>>
	<!-- Start Single News -->
	<div class="single-news <?php if(has_post_thumbnail()){ ?>has-thumbanil<?php } echo esc_attr($bizindustries_animation);?>">
		
		<!-- Start Entry Thumb -->
		<?php bizindustries_post_thumbnail(); ?>
		<!-- End Entry Thumb -->
		
		<!-- Start Entry Header -->
		<div class="entry-header-wrap">
			<div class="entry-header"> 
				<?php
					the_title( '<h4><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
				?>
				<div class="entry-meta"> 
					<?php bizindustries_posted_in(); ?>
					<?php bizindustries_post_comments(); ?>
				</div>
			</div>
			<?php
				bizindustries_posted_on();
			?>
		</div>
		<!-- End Post Header -->
		<!-- Start Entry Content -->
		<div class="entry-content"> 
			<?php
				the_excerpt();
			?>
			<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e('Read More','bizindustries'); ?></a>
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'bizindustries' ),
					'after'  => '</div>',
				) );
			?>
		</div>
		<!-- End Post Content -->
	</div>
	<!-- End Single News -->
	
</article>
