<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Bizindustries
 */

get_header();

	$post_detail_layout = get_theme_mod( 'blog_single_layout', 'right-sidebar' );
	if( $post_detail_layout == 'left-sidebar' || $post_detail_layout == 'right-sidebar' ) :
		$content_class = 'col-sm-12 col-md-12 col-lg-9';
		$aside_class = 'col-sm-12 col-md-12 col-lg-3';
	else :
		$content_class = 'col-sm-12 col-md-12 col-lg-12';
	endif;
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable', 0 ) ? 'animate-box':''; 
?>

	<!-- Start Page Banner -->
	<?php do_action('bizindustries_page_header'); ?>
	<!-- End Page Banner -->
	
	<!-- Stat Page ID -->
	<div id="page" class="site">
		<!-- Start Site Content -->
		<div class="site-content ptb-100">	
			<div class="container">
				<div class="row">
					<!--Start Sidebar -->
					<?php if($post_detail_layout == 'left-sidebar') : ?>
					<div class="col-xs-12 <?php echo esc_attr( $aside_class ); ?>">
						<?php get_sidebar(); ?>
					</div>	
					<?php endif; ?>
					<!--End Sidebar -->
					
					<div class="col-xs-12 <?php echo esc_attr( $content_class ); ?>"> 
						<div id="primary" class="content-area">
							<main id="main" class="site-main">
								<?php 
								/* Start the Loop */
								while ( have_posts() ) : the_post();
									/*
									 * Include the Post-Type-specific template for the content.
									 * If you want to override this in a child theme, then include a file
									 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
									*/
									get_template_part( 'template-parts/content', 'single' );

									the_post_navigation( array(
										'next_text' => '<span class="meta-nav" aria-hidden="true"></span> ' .
										'<span class="post-title">%title</span>',
										'prev_text' => '<span class="meta-nav" aria-hidden="true"></span> ' .
											'<span class="post-title">%title</span>',
									) );
									
									// Display Related posts
									if ( get_theme_mod( 'related_post_display', true) ) {
										get_template_part( 'template-parts/related-posts' );
									}

									// If comments are open or we have at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif; 

								endwhile;
								?>
							</main>
						</div>
					</div>
					<?php if($post_detail_layout == 'right-sidebar') : ?>
					<div class="col-xs-12 <?php echo esc_attr( $aside_class ); ?>">
						<?php get_sidebar(); ?>
					</div>	
					<?php endif; ?>
				</div>
			</div>
		</div>
		<!-- End Site Content -->
	</div>
	<!-- End Page ID -->
<?php
get_footer();