<?php
/**
 * Template part for displaying Product Section on front page template
 *
 * @package Bizindustries
 */
 	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$section_enable = get_theme_mod('teams_section_enable', false);
	$heading        = get_theme_mod('team_heading', __('Our Team', 'bizindustries'));
	$subheading     = get_theme_mod('team_subheading', __('Leaders', 'bizindustries'));
	$description    = get_theme_mod('team_description', __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'));
	$teams          = get_theme_mod('bizindustries_teams');
	
	if($section_enable == true) : 
		if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
	?>


	<!-- Start Team Area -->
	<div class="team-area ptb-110" id="team-section">
		<div class="container">
			
			<?php if(!empty($heading) || !empty($subheading) || !empty($description)) : ?>
			<div class="row">
				<div class="col-md-12"> 
					<!-- Start Section Heading -->
					<div class="section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>">
						<?php if(!empty($subheading)) : ?>
						<p class="sub-title"><?php echo esc_html($subheading); ?></p>
						<?php endif; ?>
						
						<?php if(!empty($heading)) : ?>
						<h2><?php echo esc_html($heading); ?></h2>
						<?php endif; ?>
						
						<?php if(!empty($description)) : ?>
						<p class="desc"><?php echo esc_html($description); ?></p>
						<?php endif; ?>
					</div>
					<!-- End Section Heading -->
				</div>
			</div>
			<?php endif; ?>


			<?php
			if($teams) :
			
			$carousel_enable = get_theme_mod('team_carousel_enable', true);
			
			?>

			<div class="row">
				<?php
				if( $carousel_enable == true) echo '<div class="team-carousel owl-carousel carousel-ctls">';
				
					foreach( $teams as $team ){
					$image          = ( isset( $team['image'] ) && $team['image'] ) ? $team['image'] : '';
					$name           = ( isset( $team['name'] ) && $team['name'] ) ? $team['name'] : '';
					$position       = ( isset( $team['position'] ) && $team['position'] ) ? $team['position'] : '';
					$facebook_link  = ( isset( $team['facebook_link'] ) && $team['facebook_link'] ) ? $team['facebook_link'] : '';
					$twitter_link   = ( isset( $team['twitter_link'] ) && $team['twitter_link'] ) ? $team['twitter_link'] : '';
					$instagram_link = ( isset( $team['instagram_link'] ) && $team['instagram_link'] ) ? $team['instagram_link'] : '';
					$linkedin_link  = ( isset( $team['linkedin_link'] ) && $team['linkedin_link'] ) ? $team['linkedin_link'] : '';
					$dribble_link   = ( isset( $team['dribble_link'] ) && $team['dribble_link'] ) ? $team['dribble_link'] : '';
					?>
					<div class="col-sm-12 col-md-6 col-lg-4">
						<!-- Start Member -->
						<div class="member-wrap">
						<?php
						$image = wp_get_attachment_image_src($image, 'bizindustries-team'); 
						if (!empty($image[0])) { 
							$img_src= $image[0];
						} else { 
							$img_src = '';
						}
						if(!empty($img_src)) : ?>
							<figure class="member-figure">
								<img src="<?php echo esc_url($img_src); ?>" />
							</figure>
						<?php endif; ?>

						<?php
						if(!empty($name) || !empty($position)) : ?>	
							<div class="member-info">
								<div class="member-inner">
									<div class="member-name-role"> 
										<?php if(!empty($name)) : ?>
										<h4><?php echo esc_html($name); ?></h4>
										<?php endif; ?>
										
										<?php if(!empty($position)) : ?>
										<p class="role"><?php echo esc_html($position); ?></p>
										<?php endif; ?>
									</div>
										<?php
									if(!empty($facebook_link) || !empty($twitter_link) || !empty($instagram_link) || !empty($linkedin_link) || !empty($dribble_link)) : ?>	
									<div class="social-icons crcl">
										
										<?php if(!empty($facebook_link)) : ?>
										<a href="<?php echo esc_url($facebook_link); ?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a>
										<?php endif; ?>
										
										<?php if(!empty($twitter_link)) : ?>
										<a href="<?php echo esc_url($twitter_link); ?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a>
										<?php endif; ?>
										
										<?php if(!empty($instagram_link)) : ?>
										<a href="<?php echo esc_url($instagram_link); ?>" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a>
										<?php endif; ?>
										
										<?php if(!empty($linkedin_link)) : ?>
										<a href="<?php echo esc_url($linkedin_link); ?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
										<?php endif; ?>
										
										<?php if(!empty($dribble_link)) : ?>
										<a href="<?php echo esc_url($dribble_link); ?>" target="_blank"><i class="fa fa-dribbble" aria-hidden="true"></i></a>
										<?php endif; ?>
										
									</div>
									<?php
									endif; ?>
								</div>
							</div>
							<?php
						endif; ?>
						</div>
						<!-- End Member -->
					</div>
				<?php
				}
				if( $carousel_enable == true) echo '</div>'; ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
	</div>
	<!-- End Team Area -->
	
	<?php } endif; ?>