<?php
/**
 * Template part for displaying Slogan Section on front page template
 *
 * @package Bizindustries
 */
	$slogan_enable = get_theme_mod('slogan_section_enable', false);
	$slgn_title = get_theme_mod('slogan_title', 'To deliver <strong>Quality Output</strong> Unique, Affordable & Professional');
	$slgn_subtitle = get_theme_mod('slogan_subtitle', __('Our Mission...', 'bizindustries'));
	$slgn_bg = get_theme_mod( 'slogan_bg_image');
	$parallax = get_theme_mod( 'slogan_parallax_enable');
	
	if(true == $slogan_enable) : 
	?>
	<div id="slogan-section" class="slogan-area overlay-bg ptb-80" <?php if($parallax == true) { ?> data-stellar-background-ratio=".3" <?php } ?> style="background-image: url(<?php echo esc_url($slgn_bg); ?>);">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="slogan text-center">
						
						<?php if(!empty($slgn_title)) : ?>
						<h2 id="slogan-title"><?php echo wp_kses_post($slgn_title); ?></h2>
						<?php endif; ?>

						<?php if(!empty($slgn_subtitle)) : ?>
						<h4 id="slogan-subtitle"><?php echo esc_html($slgn_subtitle); ?></h4>
						<?php endif; ?>

					</div>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>