<?php
/**
 * Template part for displaying Slider Section on home page template
 *
 * @package Bizindustries
 */

$slider_enable         = get_theme_mod('slider_section_enable', false); 
$slide_item_count      = get_theme_mod('slides_total_items', 2);
$slides_content_type   = get_theme_mod('slides_content_type', 'slides_page');
$slider_text_alignment = get_theme_mod('slider_text_alignment');

if($slider_enable) : 
?>
<div class="slider-area">
<?php
if( $slides_content_type == 'slides_page' || $slides_content_type == 'slides_post' ) {
		
	if( $slides_content_type == 'slides_page' ) :
		for( $i=1; $i<=$slide_item_count; $i++ ) :
			$slide_posts[] = get_theme_mod( 'slide_page_'.$i );
		endfor;
		$args = array (
			'post_type'     => 'page',
			'posts_per_page'=> absint( $slide_item_count ),
			'post__in'      => $slide_posts,
			'orderby'       =>'post__in',
		);
	elseif( $slides_content_type == 'slides_post' ) :
		for( $i=1; $i<=$slide_item_count; $i++ ) :
			$slide_posts[] = get_theme_mod( 'slide_post_'.$i );
		endfor;
		$args = array (
			'post_type'     => 'post',
			'posts_per_page'=> absint( $slide_item_count ),
			'post__in'      => $slide_posts,
			'orderby'       =>'post__in',
			'ignore_sticky_posts' => true,
		); 
	endif;

	$post_loop = new WP_Query($args);                        
	if ( $post_loop->have_posts() ) :
	$i=-1; $j=0; 
	?>
	<div id="hero-slider" class="slide-controls carousel-ctls owl-carousel">
		<?php
		while ($post_loop->have_posts()) : $post_loop->the_post(); $i++; $j++;
		
			$slide_thumb = get_the_post_thumbnail_url(get_the_ID(),'full');
			$slide_subtitle[$j] = get_theme_mod( 'slider_subtitle_'.$j );
			$slide_btn2_text[$j] = get_theme_mod( 'slide_btn2_text_'.$j ); 
			$slide_btn2_url[$j] = get_theme_mod( 'slide_btn2_url_'.$j); 
			$slide_btn2_target[$j] = get_theme_mod( 'slide_btn2_target_'.$j ); 
			$slide_btn2_target[$j] = $slide_btn2_target[$j]?'target="_blank"' : '';
		?>
		<div class="single-slide" style="background-image: url(<?php echo esc_url( $slide_thumb ); ?>);">
			<!-- Slider Gradient -->
			<div class="slider-gradient"></div>
			<div class="slide-wrap">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 col-md-12 col-lg-12">
							<!-- Start slide content	-->
							<div class="slide-content <?php echo esc_attr($slider_text_alignment); ?>">

								<?php if(!empty($slide_subtitle[$j])) : ?>
								<h4><?php echo esc_html($slide_subtitle[$j]); ?></h4>
								<?php endif; ?>
								
								<h2><?php the_title(); ?></h2>
								<p><?php
								if ( ! has_excerpt() ) {
									echo esc_html( wp_trim_words( get_the_content(), 18 ) );
								} else { 
									the_excerpt();
								} 
								?></p>
								<a href="<?php the_permalink(); ?>" class="btn btn-bizin btn-lg"><?php esc_html_e('See More', 'bizindustries'); ?></a>
								
								<?php if($slide_btn2_text[$j] && $slide_btn2_url[$j]) : ?>
								<a href="<?php echo esc_url($slide_btn2_url[$j]); ?>" <?php echo esc_attr($slide_btn2_target[$j]); ?> class="btn btn-bizin-2 btn-lg"><?php echo esc_html($slide_btn2_text[$j]); ?></a>
								<?php endif; ?>

							</div>
							<!-- End slide content	-->
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
		endwhile; ?>
	</div>
	<?php
	endif; 
	wp_reset_postdata(); 

} else { if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){ ?>

	<div id="hero-slider" class="slide-controls carousel-ctls owl-carousel">
		<?php
		for( $i=1; $i<=$slide_item_count; $i++ ) :
			$slide_subtitle = get_theme_mod( 'slider_subtitle_'.$i,  __('Brand','bizindustries'));
			$slide_title = get_theme_mod( 'slide_title_'.$i,  __('Known Far & Wide','bizindustries'));
			$slide_desc = get_theme_mod( 'slide_description_'.$i,  __('Our brands are the most recognized in the industry. Don\'t believe it? Check out the independent research that shows our products at the top of the list for quality','bizindustries')); 
			
			$btn1_text = get_theme_mod( 'slide_btn_text_'.$i, __('See More','bizindustries')); 
			$btn1_url = get_theme_mod( 'slide_btn_url_'.$i); 
			$btn1_target = get_theme_mod( 'slide_btn_target_'.$i ); 
			$btn1_target = $btn1_target ? 'target="_blank"' : '';
			
			$btn2_text = get_theme_mod( 'slide_btn2_text_'.$i, __('Get in Touch','bizindustries')); 
			$btn2_url = get_theme_mod( 'slide_btn2_url_'.$i); 
			$btn2_target = get_theme_mod( 'slide_btn2_target_'.$i ); 
			$btn2_target = $btn2_target ? 'target="_blank"' : '';
			
			$slide_bg_image = get_theme_mod( 'slider_bg_'.$i, get_template_directory_uri() . '/assets/img/slides/6.jpg' );
			
		?>
		<div class="single-slide" style="background-image: url(<?php echo esc_url($slide_bg_image); ?>);">
			<!-- Slider Gradient -->
			<div class="slider-gradient"></div>
			<div class="slide-wrap">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 col-md-12 col-lg-12">
							<!-- Start slide content	-->
							<div class="slide-content <?php echo esc_attr($slider_text_alignment); ?>">
								
								<?php if($slide_subtitle) : ?>
								<h4><?php echo esc_html($slide_subtitle); ?></h4>
								<?php endif; ?>
								
								<?php if($slide_title) : ?>
								<h2><?php echo esc_html($slide_title); ?></h2>
								<?php endif; ?>
								
								<?php if($slide_desc) : ?>
								<p><?php echo esc_html($slide_desc); ?></p>
								<?php endif; ?>

								<?php if($btn1_text && $btn1_url) : ?>
								<a href="<?php echo esc_url($btn1_url); ?>" <?php echo esc_attr($btn1_target); ?> class="btn btn-bizin btn-lg"><?php echo esc_html($btn1_text); ?></a>
								<?php endif; ?>
								
								<?php if($btn2_text && $btn2_url) : ?>
								<a href="<?php echo esc_url($btn2_url); ?>" <?php echo esc_attr($btn2_target); ?> class="btn btn-bizin-2 btn-lg"><?php echo esc_html($btn2_text); ?></a>
								<?php endif; ?>
							</div>
							<!-- End slide content	-->
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php endfor; ?>
	</div>

	<?php } 
 } ?>
	
</div>
<?php endif; ?>
		