<?php 
/**
 * Template part for displaying review Section on front page template
 *
 * @package Bizindustries
 */
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$section_enable = get_theme_mod('services_section_enable', false);
	$heading = get_theme_mod('services_section_heading');
	$subheading = get_theme_mod('services_section_subheading');
	$description = get_theme_mod('services_section_desc');
	$description_2 = get_theme_mod('services_section_desc_2');
	$item_count = get_theme_mod('services_total_items_show', 4);
	$content_type = get_theme_mod('services_content_type', 'services_page');
	$layout = get_theme_mod('services_layout', 'layout-1');
	$service_align = get_theme_mod('services_content_align', 'text-left');
	if($section_enable) : 
?>
<!-- Start Experiences Area -->
<div class="section pt115-pb65" id="services-section"> 
	<div class="container">
	<?php
	if($layout == 'layout-1') : ?>
		<div class="row">
			<div class="col-md-12 col-lg-6">
				<div class="intro-content <?php echo esc_attr($bizindustries_animation); ?>"> 
					<?php if(!empty($heading)) : ?>
					<h3><?php echo wp_kses_post($heading); ?></h3>
					<?php endif; ?>
					
					<?php if(!empty($description)) : ?>
					<p class="des-1"><?php echo esc_html($description); ?></p>
					<?php endif; ?>
					
					<?php if(!empty($description_2)) : ?>
					<p class="des-2"><?php echo esc_html($description_2); ?></p>
					<?php endif; ?>
				</div>
				<?php if(true === get_theme_mod('countdown_enable', false)) : ?>
                <div class="countdown-area">
					<div class="row">
					<?php
					for( $i=1; $i<=3; $i++ ) :

						$icon = get_theme_mod( 'countdown_icon_'.$i, 'fa-coffee');
						$number = get_theme_mod( 'countdown_number_'.$i,  __('123','bizindustries'));
						$description = get_theme_mod( 'countdown_desc_'.$i,  __('Winning Awards','bizindustries'));

						?>
						<div class="col-md-4 <?php echo esc_attr($bizindustries_animation); ?>">
							<div class="count-down">
								<?php if(!empty($icon)) : ?>
									<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
								<?php endif; ?>
								
								<?php if(!empty($number)) : ?>
									<h5><span class="counter"><?php echo esc_html($number); ?></span></h5>
								<?php endif; ?>
								
								<?php if(!empty($description)) : ?>
									<p><?php echo esc_html($description); ?></p>
								<?php endif; ?>
							</div>
						</div>
						<?php
					endfor; ?>
					</div>
				</div>
				<?php endif; ?>
			</div>

			<div class="col-md-12 col-lg-6">
			<?php
	if($content_type == 'services_page' || $content_type == 'services_post') {
		if( $content_type == 'services_page' ) :
			for( $i=1; $i<=$item_count; $i++ ) :
				$service_posts[] = get_theme_mod( 'featured_service_page_'.$i );
			endfor;  
			$args = array (
				'post_type'     => 'page',
				'posts_per_page' => absint( $item_count ),
				'post__in'      => $service_posts,
				'orderby'       =>'post__in',
			);
		elseif( $content_type == 'services_post' ) :
			for( $i=1; $i<=$item_count; $i++ ) :
				$service_posts[] = get_theme_mod( 'featured_service_post_'.$i );
			endfor;
			$args = array (
				'post_type'     => 'post',
				'posts_per_page' => absint( $item_count ),
				'post__in'      => $service_posts,
				'orderby'       =>'post__in',
				'ignore_sticky_posts' => true,
			);
		else :
			$args = array ();
		endif;

			$post_loop = new WP_Query($args);                        
			if ( $post_loop->have_posts() ) :
				?>
				<div class="intro-items">
					<div class="row">
						<?php
						$i= 0;
						while ($post_loop->have_posts()) : $post_loop->the_post(); $i++;
						$icon = get_theme_mod( 'service_icon_'.$i, 'fa-signal' ); 
						?>
						<div class="col-md-6"> 
							<!-- Start Icon Box -->
							<div class="icon-box <?php echo esc_attr($bizindustries_animation); ?>">
								<?php if(!empty($icon)) : ?>
								<div class="icon-holder bounce-in br-3"> 
									<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
								</div>
								<?php endif; ?>

								<h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
								<p><?php
								if ( ! has_excerpt() ) {
									echo esc_html( wp_trim_words( get_the_content(), 12 ) );
								} else { 
									the_excerpt();
								} 
								?></p>
								<a class="more-btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'bizindustries'); ?></a>
							</div>
							<!-- End Icon Box -->
						</div>
						<?php
						endwhile; ?>
					</div>
				</div>
			<?php
			endif; 
			wp_reset_postdata(); ?>
		<?php
	} else { ?>
				<div class="intro-items">
					<div class="row">
						<?php
						for( $i=1; $i<=$item_count; $i++ ) :
							$icon = get_theme_mod( 'service_icon_'.$i, 'fa-stethoscope' );
							$service_title = get_theme_mod( 'featured_service_title_'.$i);
							$service_desc = get_theme_mod( 'featured_service_desc_'.$i); 
							$service_btn_text = get_theme_mod( 'featured_service_btn_text_'.$i); 
							$servicee_btn_url = get_theme_mod( 'featured_service_btn_url_'.$i); 
							$service_btn_target = get_theme_mod( 'featured_service_btn_target_'.$i );
							$service_btn_trgt = $service_btn_target ? 'target="_blank"' : '';
						?>
						<div class="col-md-6"> 
							<!-- Start Icon Box -->
							<div class="icon-box <?php echo esc_attr($bizindustries_animation); ?>">

								<?php if(!empty($icon)) : ?>
								<div class="icon-holder bounce-in br-3"> 
									<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
								</div>
								<?php endif; ?>

								<?php if(!empty($service_title) ) : ?>
									<?php if(!empty($servicee_btn_url)) { ?>
										<h6><a href="<?php echo esc_url($servicee_btn_url); ?>" <?php echo esc_attr($service_btn_trgt); ?>><?php echo esc_html($service_title); ?></a></h6>
									<?php } else { ?>
										<h6><?php echo esc_html($service_title); ?></h6>
									<?php } ?>
								<?php endif; ?>

							<?php if(!empty($service_desc) ) : ?>
								<p><?php echo esc_html($service_desc); ?></p>
							<?php endif; ?>

							<?php if(!empty($servicee_btn_url)) : ?>
							<a href="<?php echo esc_url($servicee_btn_url); ?>" <?php echo esc_attr($service_btn_trgt); ?> class="more-btn"><?php echo esc_html($service_btn_text); ?></a>
							<?php endif; ?>

							</div>
							<!-- End Icon Box -->
						</div>
						<?php endfor; ?>	
					</div>
				</div>
				<?php
			} ?>
			</div>
		</div>
		<?php
	else : ?>
		<div class="row"> 
			<div class="col-md-12">
				<!-- Start Section Heading -->
				<div class="section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>">

					<?php if(!empty($subheading)) : ?>
					<p class="sub-title"><?php echo esc_html($subheading); ?></p>
					<?php endif; ?>
					
					<?php if(!empty($heading)) : ?>
					<h2><?php echo wp_kses_post($heading); ?></h2>
					<?php endif; ?>

					<?php if(!empty($description)) : ?>
					<p><?php echo esc_html($description); ?></p>
					<?php endif; ?>

				</div>
				<!-- End Section Heading -->
			</div>
		</div>

		<?php
		if($content_type == 'services_page' || $content_type == 'services_post') {
			if( $content_type == 'services_page' ) :
				for( $i=1; $i<=$item_count; $i++ ) :
					$service_posts[] = get_theme_mod( 'featured_service_page_'.$i );
				endfor;  
				$args = array (
					'post_type'     => 'page',
					'posts_per_page' => absint( $item_count ),
					'post__in'      => $service_posts,
					'orderby'       =>'post__in',
				);
			elseif( $content_type == 'services_post' ) :
				for( $i=1; $i<=$item_count; $i++ ) :
					$service_posts[] = get_theme_mod( 'featured_service_post_'.$i );
				endfor;
				$args = array (
					'post_type'     => 'post',
					'posts_per_page' => absint( $item_count ),
					'post__in'      => $service_posts,
					'orderby'       =>'post__in',
					'ignore_sticky_posts' => true,
				);
			else :
			    $args = array ();
			endif;

			$post_loop = new WP_Query($args);                        
		if ( $post_loop->have_posts() ) :
			?>
		<div class="row">
			<?php
			$i= 0;
			while ($post_loop->have_posts()) : $post_loop->the_post(); $i++;
				$icon = get_theme_mod( 'service_icon_'.$i, 'fa-signal' ); 
			?>
			<div class="col-sm-12 col-md-6 col-lg-4">
				<!-- Start Icon Box -->
				<div class="icon-box <?php echo esc_attr($service_align); ?> <?php echo esc_attr($bizindustries_animation); ?>">

					<?php if(!empty($icon)) : ?>
					<div class="icon-holder icon-bg icon-sm bounce-in br-3"> 
						<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
					</div>
					<?php endif; ?>
					
					<h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>

					<p><?php
					if ( ! has_excerpt() ) {
						echo esc_html( wp_trim_words( get_the_content(), 12 ) );
					} else { 
						the_excerpt();
					} 
					?></p>

					<a class="more-btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'bizindustries'); ?></a>
				</div>
				<!-- End Icon Box -->
			</div>
			<?php
			endwhile; ?>
		</div>
		<?php
		endif; 
		wp_reset_postdata(); ?>
		<?php
		} else { ?>
			<div class="row"> 
				<?php
				for( $i=1; $i<=$item_count; $i++ ) :
					$icon = get_theme_mod( 'service_icon_'.$i, 'fa-stethoscope' );
					$service_title = get_theme_mod( 'featured_service_title_'.$i);
					$service_desc = get_theme_mod( 'featured_service_desc_'.$i); 
					$service_btn_text = get_theme_mod( 'featured_service_btn_text_'.$i); 
					$servicee_btn_url = get_theme_mod( 'featured_service_btn_url_'.$i); 
					$service_btn_target = get_theme_mod( 'featured_service_btn_target_'.$i );
					$service_btn_trgt = $service_btn_target ? 'target="_blank"' : '';
				?>
				<div class="col-sm-12 col-md-6 col-lg-4"> 
					<!-- Start Icon Box -->
					<div class="icon-box <?php echo esc_attr($service_align); ?> <?php echo esc_attr($bizindustries_animation); ?>">
						<?php if(!empty($icon)) : ?>
						<div class="icon-holder icon-bg icon-sm bounce-in br-3"> 
							<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
						</div>
						<?php endif; ?>

						<?php if(!empty($service_title) ) : ?>
							<?php if(!empty($servicee_btn_url)) { ?>
								<h6><a href="<?php echo esc_url($servicee_btn_url); ?>" <?php echo esc_attr($service_btn_trgt); ?>><?php echo esc_html($service_title); ?></a></h6>
							<?php } else { ?>
								<h6><?php echo esc_html($service_title); ?></h6>
							<?php } ?>
						<?php endif; ?>

					<?php if(!empty($service_desc) ) : ?>
						<p><?php echo esc_html($service_desc); ?></p>
					<?php endif; ?>

					<?php if(!empty($servicee_btn_url)) : ?>
					<a href="<?php echo esc_url($servicee_btn_url); ?>" <?php echo esc_attr($service_btn_trgt); ?> class="more-btn"><?php echo esc_html($service_btn_text); ?></a>
					<?php endif; ?>

					</div>
					<!-- End Icon Box -->
				</div>
				<?php endfor; ?>
			</div>
		<?php
		}
    endif; ?>
	</div>
</div>
<?php endif; ?>











