<?php
/**
 * Template part for displaying review Section on front page template
 *
 * @package Bizindustries
 */
 	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$reviews_sec_enable = get_theme_mod('reviews_sec_enable', false);
	$heading = get_theme_mod('reviews_heading', __('Reviews', 'bizindustries'));
	$subheading = get_theme_mod('reviews_subheading', __('Client Says', 'bizindustries'));
	$description = get_theme_mod('reviews_description', __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.2', 'bizindustries'));
	$total_items = get_theme_mod('reviews_total_count', 2);
	$content_type = get_theme_mod('reviews_content_type', 'reviews_page');
	$carousel_enable = get_theme_mod('reviews_carousel_enable', false);
	if($reviews_sec_enable) : 
	?>
	<!-- Start Testimonials Area -->
	<div class="testimonials-area pt115-pb65" id="review-section">
		<div class="container">
			<?php if(!empty($heading) || !empty($subheading) || !empty($description)) : ?>
			<div class="row"> 
				<div class="col-md-12">
					<!-- Start Section Heading -->
					<div class="section-heading text-center animate-box"> 
						<?php if(!empty($subheading)) : ?>
						<p class="sub-title"><?php echo esc_html($subheading); ?></p>
						<?php endif; ?>
						
						<?php if(!empty($heading)) : ?>
						<h2><?php echo esc_html($heading); ?></h2>
						<?php endif; ?>
						
						<?php if(!empty($description)) : ?>
						<p class="desc"><?php echo esc_html($description); ?></p>
						<?php endif; ?>
					</div>
					<!-- End Section Heading -->
				</div>
			</div>
			<?php endif; ?>
			
			<?php
	if( $content_type == 'reviews_page' || $content_type == 'reviews_post' ) {
		
		if( $content_type == 'reviews_page' ) :
			for( $i=1; $i<=$total_items; $i++ ) :
				$slide_posts[] = get_theme_mod( 'reviews_page_'.$i );
			endfor;
			$args = array (
				'post_type'     => 'page',
				'posts_per_page'=> absint( $total_items ),
				'post__in'      => $slide_posts,
				'orderby'       =>'post__in',
			);
		elseif( $content_type == 'reviews_post' ) :
			for( $i=1; $i<=$total_items; $i++ ) :
				$slide_posts[] = get_theme_mod( 'reviews_post_'.$i );
			endfor;
			$args = array (
				'post_type'     => 'post',
				'posts_per_page'=> absint( $total_items ),
				'post__in'      => $slide_posts,
				'orderby'       =>'post__in',
				'ignore_sticky_posts' => true,
			); 
		endif;

		$post_loop = new WP_Query($args);  
		
		if ( $post_loop->have_posts() ) :
			?>
			<div class="row">
			<?php
				if( $carousel_enable == true) echo '<div class="review-carousel owl-carousel carousel-ctls">';
				$i= 0;
				while ($post_loop->have_posts()) : $post_loop->the_post(); $i++;
				$about_rating = get_theme_mod( 'qoute_about_'.$i, __('About Quality', 'bizindustries')); 
				$designation  = get_theme_mod( 'reviewer_position_'.$i, __('Web Developer', 'bizindustries')); 
				$starnumber   = get_theme_mod( 'reviewer_stars_'.$i);
				
				?>
				<div class="col-md-6">
					<!-- Start Testimonial -->
					<div class="tistimonial <?php echo esc_attr($bizindustries_animation); ?>">
						<div class="client-pic">
							<?php if ( has_post_thumbnail() ) : ?>
							<div class="client-face"> 
								<?php the_post_thumbnail( 'thumbnail'); ?>
							</div>
							<?php endif; ?>

							<?php
							if(!empty($starnumber)) : ?>
								<div class="ratings">
								<?php 
									for($x=1;$x<=$starnumber;$x++) { ?>
									   <i class="fa fa-star" aria-hidden="true"></i>
								<?php  }
									if (strpos($starnumber,'.')) { ?>
										<i class="fa fa-star-half-o" aria-hidden="true"></i>
								<?php $x++;
									} while ($x<=5) { ?>
										<i class="fa fa-star-o" aria-hidden="true"></i>
									  <?php  $x++;
									}
								?>
								</div>
							<?php
							endif; ?>
						</div>
						<div class="quote-area <?php if(!empty($starnumber)|| has_post_thumbnail()) :?>has-face<?php endif; ?>">
							<?php if(!empty($about_rating)): ?>
							<h6><?php echo esc_html($about_rating); ?></h6>
							<?php endif; ?>
							<div class="quote">
								<?php the_content(); ?>
							</div>
							<p class="client-name"><strong><?php the_title(); ?></strong><?php if(!empty($designation)) : ?> - <?php endif; echo esc_html($designation); ?></p>
						</div>
					</div>
					<!-- End Testimonial -->
				</div>
			<?php
			endwhile;
				if( $carousel_enable == true) echo '</div>';
			?>
			</div>
			<?php
		endif; 
		wp_reset_postdata(); 
	
	} else { 
			if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){ ?>
			<div class="row">
				<?php
				for( $i=1; $i<=$total_items; $i++ ) :

				$reviewer_name = get_theme_mod( 'reviewer_name_'.$i, __('Jonathan Doe', 'bizindustries')); 
				$about_rating = get_theme_mod( 'qoute_about_'.$i, __('About Quality', 'bizindustries')); 
				$designation = get_theme_mod( 'reviewer_position_'.$i, __('Web Developer', 'bizindustries')); 
				$reviewer_quote = get_theme_mod( 'reviewer_quote_'.$i ); 
				$starnumber = get_theme_mod( 'reviewer_stars_'.$i ,5);
				$reviewer_face = get_theme_mod( 'reviewer_face_'.$i ); 

				if( $carousel_enable == true) echo '<div class="review-carousel owl-carousel carousel-ctls">';
				?>
				<div class="col-md-6">
					<!-- Start Testimonial -->
					<div class="tistimonial <?php echo esc_attr($bizindustries_animation); ?>"> 
						<div class="client-pic">
							
							<?php if(!empty($reviewer_face)) : ?>
							<div class="client-face"> 
								<img src="<?php echo esc_url($reviewer_face); ?>" alt="<?php echo esc_html($reviewer_name); ?>" />
							</div>
							<?php endif; ?>
							
							<?php
							if(!empty($starnumber)) : ?>
								<div class="ratings">
								<?php 
									for($x=1;$x<=$starnumber;$x++) { ?>
									   <i class="fa fa-star" aria-hidden="true"></i>
								<?php  }
									if (strpos($starnumber,'.')) { ?>
										<i class="fa fa-star-half-o" aria-hidden="true"></i>
								<?php $x++;
									} while ($x<=5) { ?>
										<i class="fa fa-star-o" aria-hidden="true"></i>
									  <?php  $x++;
									}
								?>
								</div>
							<?php
							endif; ?>
						</div>
						
						<div class="quote-area <?php if(!empty($starnumber) || !empty($picture)) : ?>has-face<?php endif; ?>">
							
							<?php if(!empty($about_rating)): ?>
							<h6><?php echo esc_html($about_rating); ?></h6>
							<?php endif; ?>
							
							<?php if(!empty($reviewer_quote)): ?>
							<div class="quote">
								<p><?php echo esc_html($reviewer_quote); ?></p>
							</div>
							<?php endif; ?>
							
							<?php if(!empty($reviewer_name) || !empty($designation) ) : ?>
							<p class="client-name">
								<?php if(!empty($reviewer_name)) : ?>
								<strong><?php echo esc_html($reviewer_name); ?></strong>
								<?php endif; ?>
								<?php if(!empty($designation)) : ?> - <?php echo esc_html($designation); endif; ?>
							</p>
							<?php endif; ?>
						</div>
						
					</div>
					<!-- End Testimonial -->
				</div>
				<?php  
				if( $carousel_enable == true) echo '</div>'; ?>

			   <?php endfor; ?>	
			</div>
			<?php
			}
		} ?>
		</div>
	</div>
<!-- End Testimonials Area -->
<?php endif; ?>