<?php
/**
 * Template part for displaying Product Section on front page template
 *
 * @package Bizindustries
 */
 	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$products_enable = get_theme_mod('products_section_enable', false);
	$heading         = get_theme_mod('products_title', __('Our Products', 'bizindustries'));
	$subheading      = get_theme_mod('products_subtitle', __('Explore', 'bizindustries'));
	$description     = get_theme_mod('products_description', __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'));
	$item_count = get_theme_mod('total_products', 3);
	$content_type = get_theme_mod('product_content_type', 'products_page');

	if( true === $products_enable ) : 
?>
	<!-- Start Products Area -->
	<div class="section bg-gray pt115-pb65" id="products-section">
		<div class="container">
			
			<?php if(!empty($heading) || !empty($subheading) || !empty($description)) : ?>
			<div class="row">
				<div class="col-md-12"> 
					<!-- Start Section Heading -->
					<div class="prodcuts-heaings section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>">
						<?php if(!empty($subheading)) : ?>
						<p class="sub-title"><?php echo esc_html($subheading); ?></p>
						<?php endif; ?>
						
						<?php if(!empty($heading)) : ?>
						<h2><?php echo esc_html($heading); ?></h2>
						<?php endif; ?>

						<?php if(!empty($description)) : ?>
						<p class="p-desc"><?php echo esc_html($description); ?></p>
						<?php endif; ?>
					</div>
					<!-- End Section Heading -->
				</div>
			</div>
			<?php endif; ?>
			

	<?php
	if($content_type == 'products_page' || $content_type == 'products_post') {
		if( $content_type == 'products_page' ) :
			for( $i=1; $i<=$item_count; $i++ ) :
				$product_posts[] = get_theme_mod( 'featured_product_page_'.$i );
			endfor;  
			$args = array (
				'post_type'     => 'page',
				'posts_per_page' => absint( $item_count ),
				'post__in'      => $product_posts,
				'orderby'       =>'post__in',
			);
		elseif( $content_type == 'products_post' ) :
			for( $i=1; $i<=$item_count; $i++ ) :
				$product_posts[] = get_theme_mod( 'featured_product_post_'.$i );
			endfor;
			$args = array (
				'post_type'     => 'post',
				'posts_per_page' => absint( $item_count ),
				'post__in'      => $product_posts,
				'orderby'       =>'post__in',
				'ignore_sticky_posts' => true,
			);
		else :
			$args = array ();
		endif;

			$post_loop = new WP_Query($args);                        
			if ( $post_loop->have_posts() ) :
				?>

				<div class="row"> 
					<?php
					$i= 0;
					while ($post_loop->have_posts()) : $post_loop->the_post(); $i++;
					$product_img = get_theme_mod( 'product_image_'.$i);
					$btn_text    = get_theme_mod( 'product_btn_text_'.$i, __('Explore Products','bizindustries')); 
					$btn_url     = get_theme_mod( 'product_btn_url_'.$i); 
					$btn_target  = get_theme_mod( 'product_btn_target_'.$i ); 
					$btn_target  = $btn_target ? 'target="_blank"' : '';
					?>

					<div class="col-sm-12 col-md-6 col-lg-4">
						<!-- Start image-Box  -->
						<div class="image-box <?php echo esc_attr($bizindustries_animation); ?>">

							<?php if( has_post_thumbnail() ) : ?>
								<?php the_post_thumbnail('product-image'); ?>
							<?php endif; ?>

							<div class="img-des text-center">
								<h5><?php the_title(); ?></h5>
								<?php
								if ( ! has_excerpt() ) { ?>
									<p><?php echo esc_html( wp_trim_words( get_the_content(), 12 ) ); ?></p>
								<?php
								} else { 
									the_excerpt();
								} 
								?>
								<?php if($btn_text) : ?>
								<a href="<?php echo esc_url($btn_url); ?>" <?php echo esc_attr($btn_target); ?>><?php echo esc_html($btn_text); ?></a>
								<?php endif; ?>

							</div>
							<?php if(!empty($btn_text)) : ?>
							<a class="plink" href="<?php echo esc_url($btn_url); ?>" <?php echo esc_attr($btn_target); ?>><?php echo esc_html($btn_text); ?></a>
							<?php endif; ?>

						</div>
						<!-- End Image Box -->
					</div>
					<?php
					endwhile; ?>
				</div>
			<?php
			endif; 
			wp_reset_postdata(); ?>
		<?php
	} else { ?>
			<div class="row">
			<?php
			for( $i=1; $i<=$item_count; $i++ ) :

			$product_title = get_theme_mod( 'product_title_'.$i,  __('Residential Products','bizindustries'));
			$product_desc = get_theme_mod( 'product_desc_'.$i,  __('Lorem Ipsum is simply dummy text of the printing and typesetting industry.','bizindustries'));
			$product_img = get_theme_mod( 'product_image_'.$i);
			$btn_text = get_theme_mod( 'product_btn_text_'.$i, __('Explore Products','bizindustries')); 
			$btn_url = get_theme_mod( 'product_btn_url_'.$i); 
			$btn_target = get_theme_mod( 'product_btn_target_'.$i ); 
			$btn_target = $btn_target ? 'target="_blank"' : '';
			?>
				<div class="col-sm-12 col-md-6 col-lg-4">
					<!-- Start image-Box  -->
					<div class="image-box <?php echo esc_attr($bizindustries_animation); ?>">
						<?php if(!empty($product_img)) : ?>
						<img src="<?php echo esc_url($product_img); ?>" alt="<?php echo esc_attr($product_title); ?>" />
						<?php endif; ?>
						<?php if(!empty($product_title) || !empty($product_desc) || !empty($btn_text)) : ?>
						<div class="img-des text-center">
							
							<?php if(!empty($product_title)) : ?>
							<h5><?php echo esc_html($product_title); ?></h5>
							<?php endif; ?>
							
							<?php if(!empty($product_desc)) : ?>
							<p><?php echo esc_html($product_desc); ?></p>
							<?php endif; ?>

							<?php if($btn_text) : ?>
							<a href="<?php echo esc_url($btn_url); ?>" <?php echo esc_attr($btn_target); ?>><?php echo esc_html($btn_text); ?></a>
							<?php endif; ?>

						</div>
						<?php endif; ?>

						<?php if(!empty($btn_text)) : ?>
						<a class="plink" href="<?php echo esc_url($btn_url); ?>" <?php echo esc_attr($btn_target); ?>><?php echo esc_html($btn_text); ?></a>
						<?php endif; ?>

					</div>
					<!-- End Image Box -->
				</div>
				
			<?php
			endfor; ?>
			</div>
			<?php
		} ?>
		</div>
	</div>
	<!-- End Product Area -->
<?php endif; ?>