<?php
/**
* Template part for displaying Recent Posts Section on home page template
 *
 * @package Bizindustries
 */
$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':''; 
$section_enable = get_theme_mod('recent_news_enable', false); 
$heading = get_theme_mod('recent_posts_heading', __('Latest News', 'bizindustries'));
$subheading = get_theme_mod('recent_posts_subheading', __('From Blog', 'bizindustries'));
$description = get_theme_mod('recent_posts_desc', __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'));

if($section_enable == true) :
?>
<div class="news-area pt115-pb65" id="recent-news">
	<div class="container">
		
		<?php if(!empty($heading) || !empty($subheading) || !empty($description)) : ?>
		<div class="row"> 
			<div class="col-md-12">
				<!-- Start Section Heading -->
				<div class="section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>"> 
					<?php if(!empty($subheading)) : ?>
					<p class="sub-title"><?php echo esc_html($subheading); ?></p>
					<?php endif; ?>
					
					<?php if(!empty($heading)) : ?>
					<h2><?php echo esc_html($heading); ?></h2>
					<?php endif; ?>
					
					<?php if(!empty($description)) : ?>
					<p class="desc"><?php echo esc_html($description); ?></p>
					<?php endif; ?>
				</div>
				<!-- End Section Heading -->
			</div>
		</div>
		<?php endif; ?>
		<?php
			$recent_post_type = esc_attr(get_theme_mod('recent_post_content_type', 'latest-post'));
			$recent_post_cat = esc_attr(get_theme_mod('recent_post_category_choice'));
			$recent_post_count = get_theme_mod('recent_posts_total_count', 3);
			$sticky = get_option( 'sticky_posts' );
			
			if( $recent_post_type=='latest-post' ){
				$args = array( 'post_type' => 'post', 'order'=> 'DESC', 'posts_per_page' => $recent_post_count, 'ignore_sticky_posts' => 1,'post__not_in' => $sticky); 
			} else {
				$args =  array( 'post_type' => 'post', 'order'=> 'DESC', 'posts_per_page' => $recent_post_count, 'category_name' => $recent_post_cat, 'ignore_sticky_posts' => 1,'post__not_in' => $sticky);
			}
			
			$recent_post_query = new WP_Query($args); 

			if ( $recent_post_query->have_posts() ) : 
		?>
		<div class="row">
			<?php
			$carousel_enable = get_theme_mod('news_carousel_enable', false);
			if( $carousel_enable == true) echo '<div class="news-carousel owl-carousel carousel-ctls">';

			while ( $recent_post_query->have_posts() ) : $recent_post_query->the_post();?>

			<div class="col-lg-4">
				<?php 
					$thubmnail_dispay = get_theme_mod('recent_post_thumb_display', true );
					$meta_display = get_theme_mod('recent_post_meta_display', true );
					$content_display = get_theme_mod('recent_post_content_display', true);
					$readmore_display = get_theme_mod('recent_post_readmore_display', true);
					$date_display = get_theme_mod('recent_post_date_display', true);
				?>
				<div class="single-news <?php if( has_post_thumbnail() && true == $thubmnail_dispay  ){ ?>has-thumbanil <?php } echo esc_attr($bizindustries_animation);?>">

					<!-- Start Post Thumbnail -->
					<?php

						if( $thubmnail_dispay == true && has_post_thumbnail() ) : ?>
						<div class="entry-thumb"> 
							<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('bizindustries-post-thumb'); ?></a>
						</div>
						<?php endif; ?>
					<!-- End Post Thumbnail -->
					
					<!-- Start Entry Header -->
					<div class="entry-header-wrap">
						<div class="entry-header <?php if( $date_display == false ){ ?>no-date<?php }?>"> 
							<?php
								the_title( '<h4><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
								if($meta_display == true) {
									bizindustries_get_post_meta();
								}
							?>

						</div>
						<?php
							if( $date_display == true ) {
								bizindustries_posted_on();
							}
						?>
					</div>
					<!-- End Post Header -->
					
					<!-- Start Entry Content -->
					<div class="entry-content"> 
						<?php
							if( $content_display == true ) {
								the_excerpt();
							} 
							if($readmore_display == true ) {
								do_action('bizindustries_read_more_text');
							} 
							wp_link_pages( array(
								'before' => '<div class="page-links">' . __( 'Pages:', 'bizindustries' ),
								'after'  => '</div>',
							) );
						?>
					</div>
					<!-- End Post Content -->
					
				</div>
			</div>
			<?php
			endwhile;
			wp_reset_query(); 
			if( $carousel_enable == true) echo '</div>';
			?>

		</div>
		<?php 
		endif;
		wp_reset_postdata(); ?>
	</div>
</div>
<!-- End Blog Area -->
<?php endif; ?>