<?php
	/**
	 * Template part for displaying CTA Section on front page template
	 *
	 * @package Bizindustries
	 */
 
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':''; 
	$cta_enable = get_theme_mod('cta_enable', false); 
	$tile = get_theme_mod('cta_title', 'We <strong>never compromized</strong> our products quality.'); 
	$description = get_theme_mod('cta_description', __('Bizindustries Products are made in the USA at our ISO registered facilities by American workers dedicated to producing the highest quality expansion tanks in the world.', 'bizindustries'));
	$btn_text = get_theme_mod('cta_btn_text', __('Explore Products', 'bizindustries'));
	$btn_url = get_theme_mod('cta_btn_url');
	$btn_target = get_theme_mod('cta_btn_target')?'target="_blank"':'';
	
?>
<?php if($cta_enable) : ?>
<!-- Start CTA -->
<div class="cta-area bg-dark ptb-80" id="cta-section">
	<div class="container">
		<div class="row vertical-align">
			<div class="col-md-7">
				<div class="cta-wrap <?php echo esc_attr($bizindustries_animation); ?>">

					<?php if(!empty($tile)) : ?>
					<h4><?php echo wp_kses_post($tile); ?></h4>
					<?php endif; ?>
				
					<?php if(!empty($description)) : ?>
					<p><?php echo esc_html($description); ?></p>
					<?php endif; ?>
					
				</div>
			</div>
			<?php if(!empty($btn_text)) : ?>
			<div class="col-md-5"> 
				<div class="btn-wrap text-right <?php echo esc_attr($bizindustries_animation); ?>"> 
					<a href="<?php echo esc_url($btn_url); ?>" <?php echo esc_attr($btn_target); ?> class="btn btn-default btn-borders btn-lg"><?php echo esc_html($btn_text); ?></a>
				</div>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<!-- End CTA -->
<?php endif; ?>