<?php
/**
 * Template part for displaying Contact Section on front page template
 *
 * @package Bizindustries
 */
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$section_enable = get_theme_mod('contact_section_enable', false);
	$heading = get_theme_mod('contact_section_title', __('Contact Us', 'bizindustries'));
	$subheading = get_theme_mod('contact_section_subtitle', __('Give us a Call', 'bizindustries'));
	$description = get_theme_mod('contact_section_desc', __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'));
	if($section_enable == true) :
	?>
	<!-- Start Contact US -->
	<div class="section pt115-pb65" id="contact-section">
		<div class="container">
			<?php if(!empty($heading) || !empty($subheading) || !empty($description)) : ?>
			<div class="row">
				<div class="col-md-12"> 
					<!-- Start Section Heading -->
					<div class="section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>"> 
						<?php if(!empty($subheading)) : ?>
						<p class="sub-title"><?php echo esc_html($subheading); ?></p>
						<?php endif; ?>
						
						<?php if(!empty($heading)) : ?>
						<h2><?php echo esc_html($heading); ?></h2>
						<?php endif; ?>
						
						<?php if(!empty($description)) : ?>
						<p class="desc"><?php echo esc_html($description); ?></p>
						<?php endif; ?>
					</div>
					<!-- End Section Heading -->
				</div>
			</div>
			<?php endif; ?>
			<div class="row">
				<div class="col-md-12 col-lg-6 <?php echo esc_attr($bizindustries_animation); ?>">
					<?php 
						$contact_section_form = get_theme_mod('contact_section_form_shortcode'); 
						if(!empty($contact_section_form)) : ?>
						<div class="contact-form">
							<?php 
							echo do_shortcode( wp_kses_post( $contact_section_form ) );
							?>
						</div>
						<?php
							endif; 
						?>
				</div>
				<?php  
					$office_title = get_theme_mod('contact_section_office_title', __('Bizindustries Inc.', 'bizindustries'));
					$office_type = get_theme_mod('contact_section_office_type', __('Corporate Office', 'bizindustries'));
					$office_address = get_theme_mod('contact_section_office_address', __('1400 Division Road, West Warwick, R.I. 123456', 'bizindustries'));
					$office_phone = get_theme_mod('contact_section_phone', __('(401) 123-4567', 'bizindustries'));
					$office_fax = get_theme_mod('contact_section_fax', __('(401) 123-4567', 'bizindustries'));
					$office_general_email = get_theme_mod('contact_section_general_email', 'info@bizindustries.com');
					$office_warenty_email = get_theme_mod('contact_section_warenty_email', 'warranty@bizindustries.com');
					
				?>
				<div class="col-md-12 col-lg-6 <?php echo esc_attr($bizindustries_animation); ?>">
					<div class="contact-box">
						
						<?php if(!empty($office_title) || !empty($office_type)) : ?>
						<div class="contact-heading">
							
							<?php if(!empty($office_title)) : ?>
							<h4><?php echo esc_html($office_title); ?></h4>
							<?php endif; ?>
							
							<?php if(!empty($office_type)) : ?>
							<p><?php echo esc_html($office_type); ?></p>
							<?php endif; ?>

						</div>
						<?php endif; ?>
						

						<?php if(!empty($office_address)) : ?>
							<p><?php echo esc_html($office_address); ?></p>
						<?php endif; ?>
						<?php if(!empty($office_phone) || !empty($office_fax) ) : ?>
						<p> 
							<?php if(!empty($office_phone)) : ?>
							<?php esc_html_e('Phone:', 'bizindustries'); ?> <a href="<?php echo esc_url('tel:' . preg_replace( '/[^\d+]/', '', $office_phone ) ); ?>"><?php echo esc_html($office_phone); ?></a>
							<?php endif; ?>

							<?php if(!empty($office_fax)) : ?>
							| <?php esc_html_e('Fax:', 'bizindustries'); ?> <a href="<?php echo esc_url('tel:' . preg_replace( '/[^\d+]/', '', $office_fax ) ); ?>"><?php echo esc_html($office_fax); ?></a>
							<?php endif; ?>
						</p>
						<?php endif; ?>
						<?php if(!empty($office_general_email)) : ?>
						<p><?php esc_html_e('For general inquiries:', 'bizindustries'); ?> <a href="mailto:<?php echo esc_attr($office_general_email); ?>"><?php echo esc_html($office_general_email); ?></a></p>
						<?php endif; ?>
						
						<?php if(!empty($office_warenty_email)) : ?>
						<p><?php esc_html_e('For warranty inquiries:', 'bizindustries'); ?> <a href="mailto:<?php echo esc_attr($office_warenty_email); ?>"><?php echo esc_html($office_warenty_email); ?></a></p>
						<?php endif; ?>

					 </div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Contact US -->
	<?php endif; ?>