<?php
/**
 * Template part for displaying Reasons Section on front page template
 *
 * @package Bizindustries
 */
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$section_enable = get_theme_mod('whysec_enable', false);
	$heading = get_theme_mod('why_section_title', __('Why Choose', 'bizindustries'));
	$subheading = get_theme_mod('why_section_subtitle', __('The Reasons', 'bizindustries'));
	$description = get_theme_mod('why_section_desc', __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'));
	$item_count = get_theme_mod('reasons_total_items_show', 4);
	$content_type = get_theme_mod('reasons_content_type', 'reasons_page');

	if($section_enable) : 
?>
	<!-- Start Why Choose Area -->
	<div class="why-area bg-gray pt115-pb65" id="reasons-section">
		<div class="container">
			
			<?php if(!empty($heading) || !empty($subheading) || !empty($description)) : ?>
			<div class="row"> 
				<div class="col-md-12">
					<!-- Start Section Heading -->
					<div class="section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>"> 
						<?php if(!empty($subheading)) : ?>
						<p class="sub-title"><?php echo esc_html($subheading); ?></p>
						<?php endif; ?>
						
						<?php if(!empty($heading)) : ?>
						<h2><?php echo esc_html($heading); ?></h2>
						<?php endif; ?>
						
						<?php if(!empty($description)) : ?>
						<p class="desc"><?php echo esc_html($description); ?></p>
						<?php endif; ?>
					</div>
					<!-- End Section Heading -->
				</div>
			</div>
			<?php endif; ?>
			
		<?php
		if($content_type == 'reasons_page' || $content_type == 'reasons_post') {
			if( $content_type == 'reasons_page' ) :
				for( $i=1; $i<=$item_count; $i++ ) :
					$service_posts[] = get_theme_mod( 'featured_reason_page_'.$i );
				endfor;  
				$args = array (
					'post_type'     => 'page',
					'posts_per_page' => absint( $item_count ),
					'post__in'      => $service_posts,
					'orderby'       =>'post__in',
				);
			elseif( $content_type == 'reasons_post' ) :
				for( $i=1; $i<=$item_count; $i++ ) :
					$service_posts[] = get_theme_mod( 'featured_reason_post_'.$i );
				endfor;
				$args = array (
					'post_type'     => 'post',
					'posts_per_page' => absint( $item_count ),
					'post__in'      => $service_posts,
					'orderby'       =>'post__in',
					'ignore_sticky_posts' => true,
				);
			else :
				$args = array ();
			endif;

			$post_loop = new WP_Query($args);                        
		if ( $post_loop->have_posts() ) :
			?>
				<div class="row">
					<?php
					$i= 0;
					while ($post_loop->have_posts()) : $post_loop->the_post(); $i++;
						$icon = get_theme_mod( 'reasons_icon_'.$i, 'fa-bell' ); 
					?>
					<div class="col-sm-12 col-md-6 col-lg-3"> 
						<!-- Star Icon Box -->
						<div class="icon-box text-center <?php echo esc_attr($bizindustries_animation); ?>">

							<?php if(!empty($icon)) : ?>
							<div class="icon-holder icon-bg bounce-in br-50"> 
								<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
							</div>
							<?php endif; ?>

							<h6><?php the_title(); ?></h6>

							<p><?php
							if ( ! has_excerpt() ) {
								echo esc_html( wp_trim_words( get_the_content(), 12 ) );
							} else { 
								the_excerpt();
							} 
							?></p>

						</div>
						<!-- End Icon Box -->
					</div>
					<?php
					endwhile; ?>
				</div>
		<?php
		endif; 
		wp_reset_postdata(); ?>
		<?php
		} else { if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){ ?>
		<div class="row">
				<?php
				for( $i=1; $i<=$item_count; $i++ ) :
					$icon = get_theme_mod( 'reasons_icon_'.$i, 'fa-stethoscope' );
					$reason_title = get_theme_mod( 'featured_reason_title_'.$i);
					$reason_desc = get_theme_mod( 'featured_reason_desc_'.$i); 
				?>
					<div class="col-sm-12 col-md-6 col-lg-3"> 
						<!-- Star Icon Box -->
						<div class="icon-box text-center <?php echo esc_attr($bizindustries_animation); ?>">

							<?php if(!empty($icon)) : ?>
							<div class="icon-holder icon-bg bounce-in br-50"> 
								<i class="fa <?php echo esc_html($icon); ?>" aria-hidden="true"></i>
							</div>
							<?php endif; ?>

							<?php if(!empty($reason_title) ) : ?>
								<h6><?php echo esc_html($reason_title); ?></h6>
							<?php endif; ?>

							<?php if(!empty($reason_desc) ) : ?>
								<p><?php echo esc_html($reason_desc); ?></p>
							<?php endif; ?>

						</div>
						<!-- End Icon Box -->
					</div>
				<?php endfor; ?>
		</div>
		<?php } } ?>
		</div>
	</div>
<?php endif; ?>