<?php 
/**
 * Template part for displaying Brands Logo Section on front page template
 *
 * @package Bizindustries
 */
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable') ? 'animate-box':'';
	$section_enable = get_theme_mod('brands_section_enable', false);
	$heading = get_theme_mod('brands_section_heading');
	$subheading = get_theme_mod('brands_section_subheading');
	$brands = get_theme_mod('bizindustries_brands');

if($section_enable) : 
	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
?>
<div class="brands-area bg-gray" id="brands-section">
	<div class="container">
		
		<?php if(!empty($heading) || !empty($subheading) ) : ?>
		<div class="row">
			<div class="col-md-12"> 
				<!-- Start Section Heading -->
				<div class="section-heading text-center <?php echo esc_attr($bizindustries_animation); ?>">
					<?php if(!empty($subheading)) : ?>
					<p class="sub-title"><?php echo esc_html($subheading); ?></p>
					<?php endif; ?>
					
					<?php if(!empty($heading)) : ?>
					<h2><?php echo esc_html($heading); ?></h2>
					<?php endif; ?>

				</div>
				<!-- End Section Heading -->
			</div>
		</div>
		<?php endif; ?>

		<div class="row">
				<?php
				if($brands) :
					?>
				<div class="brand-logos owl-carousel carousel-ctls pb-10">
				<?php
					foreach( $brands as $brand ){
					$image        = ( isset( $brand['image'] ) && $brand['image'] ) ? $brand['image'] : '';
					$btitle        = ( isset( $brand['title'] ) && $brand['title'] ) ? $brand['title'] : '';
					$btn_url      = ( isset( $brand['link'] ) && $brand['link'] ) ? $brand['link'] : '';
					$btn_target   = ( isset( $brand['checkbox'] ) && $brand['checkbox']) ? '_blank' : '_self';
					?>
					<div class="single-logo">
						<?php
						$image = wp_get_attachment_image_src($image, 'bizindustries-brand'); 
						if (!empty($image[0])) { 
							$img_src= $image[0];
						} else { 
							$img_src = '';
						}
						
						if(!empty($btn_url)) : ?>
							<a href="<?php echo esc_url($btn_url); ?>"  target="<?php echo esc_attr( $btn_target ); ?>" title="<?php echo esc_attr( $btitle ); ?>">
								<img src="<?php echo esc_url($img_src); ?>" alt="<?php echo esc_attr( $btitle ); ?>" />
							</a>
						<?php else : ?>
							<img src="<?php echo esc_url($img_src); ?>" alt="<?php echo esc_attr( $btitle ); ?>" />
						<?php endif; ?>
						
					</div>
				<?php } ?>

				</div>
				<?php
				endif; ?>
		</div>
	</div>
</div>

<?php } endif; ?>