<?php
/**
 * Template Name: Contact Page
 *
 * @package Bizindustries
*/
	get_header();
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable', 0 ) ? 'animate-box':'';
	$address_title    = get_theme_mod( 'address_title', __('Address', 'bizindustries'));
	$contact_address  = get_theme_mod( 'contact_address', __('655 Montgomery Street,7th Floor, San Francisco, United State 94111', 'bizindustries'));
	$phone_title      = get_theme_mod( 'phone_title', __('Phone', 'bizindustries'));
	$phone_1_label  = get_theme_mod( 'phone_1_label', __('For general information:', 'bizindustries'));
	$phone_1     = get_theme_mod( 'phone_1', __('+0123-456-789', 'bizindustries'));
	$phone_2_label     = get_theme_mod( 'phone_2_label', __('For Support', 'bizindustries'));
	$phone_2    = get_theme_mod( 'phone_2', __('+0123-456-789', 'bizindustries'));
	$mail_title    = get_theme_mod( 'mail_title', __('Email', 'bizindustries'));
	$email_1_label  = get_theme_mod( 'email_1_label', __('For general information', 'bizindustries'));
	$email_1  = get_theme_mod( 'email_1', 'info@Bizindustries.com');
	$email_2_label  = get_theme_mod( 'email_2_label', __('For Quick Support:', 'bizindustries'));
	$email_2 = get_theme_mod( 'email_2', 'warranty@Bizindustries.com');
	
	$form_title       = get_theme_mod( 'contact_form_title', __('Get in Touch', 'bizindustries'));
	
	
	$google_map = get_theme_mod( 'contact_google_map_iframe' );
?>
<!-- Start Page Header -->
<?php do_action('bizindustries_page_header'); ?>
<!-- Start Page Header -->
	
<div id="page" class="site">
	<!-- Start Site Content -->
	<div class="site-content ptb-100">	
		<div class="container">
			<div class="row">
				
				<div class="col-md-12 col-lg-6 <?php echo esc_attr($bizindustries_animation);?>">
					<div class="contact-item mb-30"> 
						<h5><?php echo esc_html($address_title); ?></h5>
						<address>
							<?php 
								echo wp_kses_post(str_replace('|', '<br />', $contact_address));
							?>
						</address>
					</div>
					<div class="contact-item mb-30"> 
						<h5><?php echo esc_html($phone_title); ?></h5>
						<div class="phones"> 
							<?php echo esc_html($phone_1_label); ?> <a href="<?php echo esc_url('tel:' . preg_replace( '/[^\d+]/', '', $phone_1 ) ); ?>"><?php echo esc_html($phone_1); ?></a><br>
							<?php echo esc_html($phone_2_label); ?> <a href="<?php echo esc_url('tel:' . preg_replace( '/[^\d+]/', '', $phone_2 ) ); ?>"><?php echo esc_html($phone_2); ?></a>
						</div>
					</div>
					<div class="contact-item  mb-50"> 
						<h5><?php echo esc_html($mail_title); ?></h5>
						<div class="emails"> 
							<?php echo esc_html($email_1_label); ?> <a href="mailto:<?php echo esc_html($email_1); ?>"><?php echo esc_html($email_1); ?></a><br>
							<?php echo esc_html($email_2_label); ?> <a href="mailto:<?php echo esc_html($email_2); ?>"><?php echo esc_html($email_2); ?></a>
						</div>
					</div>
				</div>

				<div class="col-md-12 col-lg-6 <?php echo esc_attr($bizindustries_animation);?>">
					<?php if ($form_title) : ?>
					<h3><?php echo esc_html($form_title); ?></h3>
					<?php endif; ?>

					<?php 
					$form_shortcode = get_theme_mod( 'contact_form_shortcode' );  
					if($form_shortcode) : ?>
					<div class="contact-form"> 
						<?php echo do_shortcode( $form_shortcode ); ?>
					</div>
					<?php endif; ?>
					<!-- End contact form -->
				</div>
			</div>
		</div>
	</div>
	<!-- End Site Content -->
</div>

<?php if( $google_map ): ?> 
<div class="map-area">
	<div class="fullwide-map"> 
	     <?php echo htmlspecialchars_decode( $google_map ); ?>
	</div>
</div>
<?php endif; ?>

<?php get_footer(); ?>