<?php

/**
* Cart Fragments
*/
if ( ! function_exists( 'bizindustries_woocommerce_cart_link_fragment' ) ) :

	function bizindustries_woocommerce_cart_link_fragment( $fragments ) {
		ob_start();
		bizindustries_woo_header_cart();
		$fragments['a.woo-cart'] = ob_get_clean();

		return $fragments;
	}
endif;

add_filter( 'woocommerce_add_to_cart_fragments', 'bizindustries_woocommerce_cart_link_fragment' );



if ( ! function_exists( 'bizindustries_woo_header_cart' ) ) :

	function bizindustries_woo_header_cart(){
		$cart_page      = get_option( 'woocommerce_cart_page_id' );
		$bizin_cart_icon_title = apply_filters( 'bizin_cart_icon_title', esc_html__( 'View your shopping cart', 'bizindustries' ) );
		$count          = WC()->cart->cart_contents_count;
		$cart_icon_dis = get_theme_mod( 'header_cart_icon_display', true );
		if( $cart_icon_dis && $cart_page ){ 
		?>
			<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="woo-cart" title="<?php echo esc_attr( $bizin_cart_icon_title ); ?>">
				<svg xmlns="http://www.w3.org/2000/svg" width="33" height="33" viewBox="0 0 33 33">
					<path id="Path_10" data-name="Path 10" d="M1505.694,120.218l-22.707-.039-.643-3.545a1.989,1.989,0,0,0-1.958-1.634h-4.419a.967.967,0,1,0,0,1.934c4.679,0,4.461-.026,4.474.046,1.049,5.777.381,1.74,3.2,19.749l-2.48.013a1.945,1.945,0,0,0-1.922,2.185l.274,2.193a1.948,1.948,0,0,0,1.929,1.7h1.716a3.555,3.555,0,1,0,6.325,0h9.208a3.555,3.555,0,1,0,6.325,0h2.015a.966.966,0,1,0,0-1.933c-26.795,0-25.6,0-25.6-.009a18.155,18.155,0,0,1-.263-2.2c12.875-.067-17.9,0,23.783,0a2.984,2.984,0,0,0,3.046-3.055v-13.1A2.311,2.311,0,0,0,1505.694,120.218Zm-17.75,24.226a1.622,1.622,0,1,1-1.622-1.622,1.623,1.623,0,0,1,1.622,1.622Zm15.534,0a1.622,1.622,0,1,1-1.623-1.622,1.624,1.624,0,0,1,1.623,1.622Zm2.588-21.919v5.946h-6.252l.791-6.328,5.086.009A.374.374,0,0,1,1506.066,122.525Zm-13.709,14.221-.793-6.342h6.06l-.793,6.342Zm-6.754,0-.994-6.342h5.006l.793,6.342Zm5.719-8.275-.793-6.345,8.128.014-.792,6.331Zm-2.742-6.349.794,6.349h-5.067l-1-6.358Zm16.374,14.624h-6.175l.793-6.342h6.494v5.221A1.057,1.057,0,0,1,1504.954,136.746Z"
						transform="translate(-1475 -115)" fill="#040505" />
				</svg>
				<span class="count">
					<?php echo absint( $count ); ?>
				</span>
			</a>
		<?php 
		}
	}
endif;


/**
 * Change number or products per row to 3
 */
if (!function_exists('bizindustries_loop_columns')) :
	
	function bizindustries_loop_columns() {
		return 3; // 3 products per row
	}
	
endif;
add_filter('loop_shop_columns', 'bizindustries_loop_columns', 999);


if (!function_exists('bizindustries_related_products_args')) :
	function bizindustries_related_products_args( $args ) {
	
		$args['posts_per_page'] = get_theme_mod('related_products_per_row', 3); 
		$args['columns'] = get_theme_mod('related_products_per_row', 3);
		return $args;
	}
endif;
add_filter( 'woocommerce_output_related_products_args', 'bizindustries_related_products_args', 20 );

