<?php


if ( ! function_exists( 'bizindustries_secondary_nav' ) ) :
	/**
	 * Secondary Navigaion
	  * Since 1.0.0
	*/
	function bizindustries_secondary_nav() {

	  ?>
		<nav class="secondary-nav"> 
			<?php if (function_exists('wp_nav_menu')) {
				wp_nav_menu( array( 
						'theme_location' => 'secondary-menu',
						'container'  => 'ul',
						'depth'      => 1,
						'fallback_cb' => 'bizindustries_default_menu' 
					) );
					}
				else {
					bizindustries_default_menu();
				}
			?>
		</nav>
		<?php

	}
endif;


if ( ! function_exists( 'bizindustries_default_menu' ) ) :
	/**
	 * Default fallback menu
	 * Since 1.0.0
	*/
	function bizindustries_default_menu() {

	  ?>
	    <ul class="menu">
		   <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'bizindustries' ); ?></a></li>
		   <li><a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ) ; ?>"><?php esc_html_e( 'Add Menu', 'bizindustries' ); ?></a></li>
	    </ul>
		<?php

	}
endif;



if( ! function_exists( 'bizindustries_social_links' ) ) :
	/**
	 * Social Links
	 * Since 1.0.0
	*/
	function bizindustries_social_links( $echo = true ){
		
		$social_links = get_theme_mod( 'social_links' );
			
		if( $social_links && $echo ){ ?>
		
		<div class="social-icons crcl"> 
			<?php 
			foreach( $social_links as $link ){
				$new_tab = isset( $link['checkbox'] ) && $link['checkbox'] ? '_blank' : '_self';
				if( isset( $link['link'] ) ){ ?>

					<a href="<?php echo esc_url( $link['link'] ); ?>" target="<?php echo esc_attr( $new_tab ); ?>" rel="nofollow noopener">
						<?php echo wp_kses( bizindustries_social_icon_list( $link['icon'] ), get_kses_extended_ruleset() ); ?>
					</a>
		   
				<?php
				} 
			} 
			?>
		</div>
		<?php    
		}elseif( $social_links ){
			return true;
		}else{
			return false;
			}                               
	}
endif;
	

if ( ! function_exists( 'bizindustries_site_logo' ) ) :
	/**
	 * Site Branding
	 * Since 1.0.0
	*/
	function bizindustries_site_logo() {

	$logo_option = get_theme_mod( 'site_logo_option' );
	if ( 'logo-only' == $logo_option )  { ?>
		<div class="stie-logo">
			<?php 
			if( has_custom_logo() ) {  
				the_custom_logo(); 
			} ?>
		</div>   
	<?php } elseif( 'title-only' == $logo_option  ) { ?>
		<div class="text-logo">
			<?php if( is_home() && is_front_page() ) : ?>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h1>
			<?php else : ?>
			<h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h2>
			<?php endif; ?>
		</div>
	<?php } elseif( 'title-img' == $logo_option ) { ?>
		<div class="logo-title"> 
			<?php 
			if( has_custom_logo() ) {  
				the_custom_logo(); 
			}  ?>
			<?php if( is_home() && is_front_page() ) : ?>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h1>
			<?php else : ?>
			<h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h2>
			<?php endif; ?>
		</div>		
	<?php } else {  ?>	
		<div class="text-logo-desc">
			<?php if( is_home() && is_front_page() ) : ?>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h1>
			<?php else : ?>
			<h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h2>
			<?php endif; ?>
			<p class="site-description"><?php echo esc_html( bloginfo( 'description' ) ); ?></p>
		</div>
	<?php }

	}
endif;
	

if ( ! function_exists( 'bizindustries_site_nagivation' ) ) :
	/**
	 * Site Navigation
	 * Since 1.0.0
	*/
	function bizindustries_site_nagivation() {
	?>
	<nav class="bizin-nav">
		<?php
			if(class_exists('Bootitems_Core_Nav_Walker') && bizindustries_set_to_premium()){
				wp_nav_menu(
					array(
						'theme_location' => 'primary-menu',
						'container'      => 'ul',
						'menu_class'     => 'menu',
						'fallback_cb'    => 'Bootitems_Core_Nav_Walker::fallback',
						'walker'         => new Bootitems_Core_Nav_Walker()
					)
				);
			} else {
				wp_nav_menu(
					array(
						'theme_location' => 'primary-menu',
						'container'      => 'ul',
						'menu_class'     => 'menu',
						'fallback_cb'    => 'bizindustries_default_menu',
					)
				);
			}
		?>
	</nav>
	<?php
	}
endif;


if ( ! function_exists( 'bizindustries_get_posts_pagination' ) ) :
	/**
	 * Pagination
	 * Since 1.0.0
	*/
    function bizindustries_get_posts_pagination( $query = null ) {

        $classes = [];

        if ( empty( $query ) ) {
            $query = $GLOBALS['wp_query'];
        }

        if ( empty( $query->max_num_pages ) 
                || ! is_numeric( $query->max_num_pages )
                || $query->max_num_pages < 2 ) {
            return;
        }

        $paged = get_query_var( 'paged' );

        if ( ! $paged && is_front_page() && ! is_home() ) {
            $paged = get_query_var( 'page' );
        }

        $paged = $paged ? intval( $paged ) : 1;

        $pagenum_link = html_entity_decode( get_pagenum_link() );
        $query_args   = array();
        $url_parts    = explode( '?', $pagenum_link );

        if ( isset( $url_parts[1] ) ) {
            wp_parse_str( $url_parts[1], $query_args );
        }

		$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
        $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

        $html_prev = '<i class="fa fa-angle-double-left" aria-hidden="true"></i> Prev';
        $html_next = 'Next <i class="fa fa-angle-double-right" aria-hidden="true"></i>';
        $links = paginate_links( array(
            'base'      => $pagenum_link,
            'total'     => $query->max_num_pages,
            'current'   => $paged,
            'mid_size'  => 2,
            'add_args'  => array_map( 'urlencode', $query_args ),
            'prev_text' => $html_prev,
            'next_text' => $html_next,
            'type'      => 'array',
        ) );
		$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable', 0 ) ? 'animate-box':'';
        if ( is_array( $links ) ) {
            $r = '<nav class="navigation paging-navigation '.$bizindustries_animation.'">';
            $r .= "<ul class='page-numbers'>\n\t<li>";
            $r .= str_replace( 'page-numbers', 'page-link', join( "</li>\n\t<li>", $links ) );
            $r .= "</li>\n</ul>\n";
            $r .= "</nav>";

            printf( $r ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        }
    }
endif;

function bizindustries_render_posts_pagination() {
	/**
	 * Pagination for archive.
	 * Since 1.0.0
	*/
	$pagination_type = get_theme_mod( 'pagination_type', 'numeric' );
	if ( 'default' === $pagination_type ) :
		the_posts_navigation();
	else :
		bizindustries_get_posts_pagination();
	endif;

}
add_action( 'bizindustries_posts_pagination', 'bizindustries_render_posts_pagination', 10 );


if ( ! function_exists( 'bizindustries_related_posts' ) ) :
	/**
	* Display the related posts.
	 * Since 1.0.0
	*/
	function bizindustries_related_posts() {
		wp_reset_postdata();
		global $post;
		
		$blog_single_layout = get_theme_mod( 'blog_single_layout', 'right-sidebar' );
		if( $blog_single_layout == 'left-sidebar' || $blog_single_layout == 'right-sidebar' ) :
			$posts_count = 2;
		else :
			$posts_count = 3;
		endif;
		
		// Define shared post arguments
		$args = array(
			'no_found_rows'          => true,
			'update_post_meta_cache' => false,
			'update_post_term_cache' => false,
			'ignore_sticky_posts'    => 1,
			'orderby'                => 'rand',
			'post__not_in'           => array( $post->ID ),
			'posts_per_page'         => $posts_count,
		);
		
		// Related by categories.
		if ( get_theme_mod( 'related_post_choice', 'categories' ) == 'categories' ) {
			$cats                 = wp_get_post_categories( $post->ID, array( 'fields' => 'ids' ) );
			$args['category__in'] = $cats;
		}
		
		// Related by tags.
		if ( get_theme_mod( 'related_post_choice', 'categories' ) == 'tags' ) {
			$tags            = wp_get_post_tags( $post->ID, array( 'fields' => 'ids' ) );
			$args['tag__in'] = $tags;

			if ( ! $tags ) {
				$break = true;
			}
		}
		$query = ! isset( $break ) ? new WP_Query( $args ) : new WP_Query();
		return $query;
	}
endif;


if( ! function_exists( 'bizindustries_banner_image' ) ) :
	/**
	* Banner Image
	 * Since 1.0.0
	*/
function bizindustries_banner_image(){
	
    $blog_banner    = get_header_image();
    $page_banner    = get_theme_mod( 'bizindustries_page_banner', get_header_image() );
    $archive_banner = get_theme_mod( 'bizindustries_archive_banner', get_header_image() );
    $search_banner  = get_theme_mod( 'bizindustries_search_banner', get_header_image() );
    $banner_404     = get_theme_mod( 'bizindustries_404_banner', get_header_image() );

    if ( is_home() ){ 
        $banner_image_url = ( ! empty( $blog_banner ) ) ? $blog_banner : get_header_image();
    }
    elseif( is_page() ){
        $banner_image_url = ( ! empty( $page_banner) ) ? $page_banner : get_header_image();
    }
    elseif( is_singular() ){
        $banner_image_url = get_the_post_thumbnail_url('full' );
        $banner_image_url = ( ! empty( $banner_image_url) ) ? $banner_image_url : get_header_image();
    }
    elseif( is_archive() ){
        $banner_image_url = ( ! empty( $archive_banner) ) ? $archive_banner : get_header_image();
    }
    elseif( is_search() ){ 
        $banner_image_url = ( ! empty( $search_banner) ) ? $search_banner : get_header_image();
    }
    elseif( is_404() ) {
        $banner_image_url = ( ! empty( $banner_404) ) ? $banner_404 : get_header_image();
    }
    return $banner_image_url;
}
endif;



if ( ! function_exists( 'bizindustries_page_header' ) ) :
/**
 * Page Header
 */
	function bizindustries_page_header(){
	$banner_url = bizindustries_banner_image();
	?>
	<!-- Start Page Header -->
	<div class="page-header" style="background-image: url(<?php echo esc_url( $banner_url ); ?>);">
		<div class="banner-gradient"></div>
		<div class="container">
			<div class="row">
				<div class="col-md-12"> 
					<div class="page-banner"> 
						<?php 
							$blog_title = get_theme_mod( 'blog_page_title', __('News & Resources', 'bizindustries') ); 
 
							if ( ( is_front_page() && is_home() ) || is_home() ){ 
							?>
								<h1 class="page-title"><?php echo esc_html( $blog_title ); ?></h1>
							<?php
							}

							if( is_page() ) {
							?>
								<h1 class="page-title"><?php echo wp_kses_post( get_the_title() ); ?></h1>
							<?php
							}    
							if( is_single() ) {
							?>
								<h1 class="page-title"><?php echo esc_html( $blog_title ); ?></h1>
							<?php
							}       

							if( is_archive() ){

								the_archive_title( '<h1 class="page-title">', '</h1>' );
								the_archive_description( '<div class="archive-description">', '</div>' );
							}

							if( is_search() ){ /* translators: Search Results for */ ?>
								<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'bizindustries' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
							<?php }

							if( is_404() ) {
								echo '<h1 class="page-title">' . esc_html__( 'Error 404', 'bizindustries' ) . '</h1>';
							}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Start Page Header -->
	<?php 
	}
endif;
add_action('bizindustries_page_header', 'bizindustries_page_header');

if ( ! function_exists( 'bizindustries_woocommerce_header' ) ) :
/**
 *WooCommerce Page Header
 */
	function bizindustries_woocommerce_header(){

	?>
	<!-- Start Page Header -->
	<div class="woo-header">
		<div class="container">
			<div class="row">
				<div class="col-md-12"> 
					<h1 class="page-title"><?php echo wp_kses_post( get_the_title() ); ?></h1>
				</div>
			</div>
		</div>
	</div>
	<!-- Start Page Header -->
	<?php 
	}
endif;
add_action('bizindustries_woocommerce_header', 'bizindustries_woocommerce_header');


/**
 * Excerpt length
 * 
 */
if ( ! function_exists( 'bizindustries_excerpt_length' ) ) :
	function bizindustries_excerpt_length( $length ){
		if ( is_admin() ) {
			return $length;
		}
		$length = get_theme_mod( 'post_excerpt_count', 20 );
		return absint( $length );
	}
endif;
add_filter( 'excerpt_length', 'bizindustries_excerpt_length', 999);


if ( ! function_exists( 'bizindustries_custom_excerpt_more' ) ) :
	/**
	 * Adds a pretty "Continue Reading" link to custom post excerpts.
	 */
	function bizindustries_custom_excerpt_more() {
		if ( ! is_attachment() ) {
			echo wp_kses_post( bizindustries_read_more_link() );
		}
	}
endif;
add_action( 'bizindustries_read_more_text', 'bizindustries_custom_excerpt_more', 10 );


if ( ! function_exists( 'bizindustries_read_more_link' ) ) :
	/**
	 * Returns a "Read More" link for excerpts
	 */
	function bizindustries_read_more_link() {
	   $link = get_permalink('');
	   $read_more = get_theme_mod('post_read_more_text', __('Read More', 'bizindustries'));
	   $new_link = '<a class="read-more" href="' . esc_url($link) . '">' . wp_kses_post( $read_more ). '</a>';

	   return $new_link;
	}
endif;
add_filter('the_content_more_link', 'bizindustries_read_more_link');

if ( ! function_exists( 'bizindustries_auto_excerpt_more' ) ) :
	/**
	 * Replaces "[...]" (appended to automatically generated excerpts) with an ellipsis and bizindustries_read_more_link().
	 */
	function bizindustries_auto_excerpt_more( $more ) {
		if ( is_admin() ) {
			return $more;
		}
		$excerpt_dots = get_theme_mod('post_excerpt_dots');
		return '<span class="exprt-dot">' . wp_kses_post( $excerpt_dots ). '</span>';
	}
endif; 
add_filter( 'excerpt_more', 'bizindustries_auto_excerpt_more' );


/**
 * Post meta info
 */
if ( ! function_exists( 'bizindustries_get_post_meta' ) ) :
	function bizindustries_get_post_meta() {
		$blog_meta_sort = get_theme_mod( 'blog_meta_sort', array('blog_author','blog_category','blog_date','blog_comment')); 

		?>
		<div class="entry-meta"> 
			<?php 
			if ( ! empty( $blog_meta_sort ) && is_array( $blog_meta_sort ) ) :
			
				foreach ( $blog_meta_sort as $blog_meta_sort_key => $blog_meta_sort_val ) :

					if ( 'blog_author' === $blog_meta_sort_val ) : ?>		
						<span><i class="fa fa-user-o" aria-hidden="true"></i> <?php the_author_posts_link(); ?> </span>
					<?php 
					endif;

					if ( 'blog_category' === $blog_meta_sort_val ) :
						if ( has_category() ) : ?>
							<span><i class="fa fa-folder-open-o" aria-hidden="true"></i> <?php the_category( __( ', ', 'bizindustries' ));?> </span>
						<?php
						endif; 
					endif;

					if ( 'blog_date' === $blog_meta_sort_val ) :
						?>
							<span><i class="fa fa-clock-o" aria-hidden="true"></i> <a href="<?php the_permalink(); ?>"><?php echo get_the_date(); ?></a></span> 
						<?php 
					endif;

					if ( 'blog_comment' === $blog_meta_sort_val ) :
						if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
							<span><i class="fa fa-commenting-o" aria-hidden="true"></i> <a href="<?php comments_link(); ?>"><?php comments_number(); ?></a></span> 
						<?php
						endif;
					endif;

				endforeach;
			endif;
			?>
		</div>
		<?php
	}
endif;


/**
 * Post navigation
 */
if ( ! function_exists( 'bizindustries_get_post_navigation' ) ) :

	function bizindustries_get_post_navigation() {
		the_post_navigation( array(
			'next_text' => '<span class="meta-nav" aria-hidden="true"></span> ' .
			'<span class="post-title">%title</span>',
			'prev_text' => '<span class="meta-nav" aria-hidden="true"></span> ' .
				'<span class="post-title">%title</span>',
		) );
	}
endif;


/**
 * Adding conatiner classes to body
 */
if ( ! function_exists( 'bizindustries_add_content_classes_to_body' ) ) :
	function bizindustries_add_content_classes_to_body($classes = '') {
		
		if('semi-width' == get_theme_mod('bizindustries_container_width')) :
			$classes[] = 'bizin-semi-width';
		else :
			$classes[] = '';
		endif;
		
		return $classes;
	}
endif;
add_filter('body_class', 'bizindustries_add_content_classes_to_body');







