<?php 
	
	
if( ! function_exists( 'bizindustries_get_phone' ) ) :
/**
 * Phone Callback
*/
function bizindustries_get_phone(){
    return get_theme_mod( 'header_phone' );
}
endif;

if( ! function_exists( 'bizindustries_get_email' ) ) :
/**
 * Email Callback
*/
function bizindustries_get_email(){
    return get_theme_mod( 'header_email' );
}
endif;


if ( ! function_exists( 'bizindustries_footer_widgets' ) ) :
	/**
	 * Footer Widgets
	 *
	 * @since 1.0.0
	*/

	function bizindustries_footer_widgets() {
		$footer_columns = absint( get_theme_mod( 'footer_layout', 4 ) );
		$max_cols = 12;
		$layouts = 12;
		if ( $footer_columns > 1 ) {
			$default = '12';
			switch ( $footer_columns ) {
				case 4:
					$default = '3+3+3+3';
					break;
				case 3:
					$default = '4+4+4';
					break;
					case 2:
					$default = '6+6';
					break;
			}
			$layouts = sanitize_text_field( get_theme_mod( 'footer_custom_' . $footer_columns . '_columns', $default ) );
		}

		$layouts = explode( '+', $layouts );
		foreach ( $layouts as $k => $v ) {
			$v = absint( trim( $v ) );
			$v = $v >= $max_cols ? $max_cols : $v;
			$layouts[ $k ] = $v;
		}

		$have_widgets = false;

		for ( $count = 0; $count < $footer_columns; $count++ ) {
			$id = 'footer-' . ( $count + 1 );
			if ( is_active_sidebar( $id ) ) {
				$have_widgets = true;
			}
		}

		if ( $footer_columns > 0 && $have_widgets ) { ?>
			<div class="footer-widgets">
				<div class="container">
					<div class="row">
						<?php
						for ( $count = 0; $count < $footer_columns; $count++ ) {
							$col = isset( $layouts[ $count ] ) ? $layouts[ $count ] : '';
							$id = 'footer-' . ( $count + 1 );
							if ( $col ) {
								?>
								<div id="footer-<?php echo esc_attr( $count + 1 ); ?>" class="col-md-<?php echo esc_attr( $col ); ?> col-sm-12" role="complementary">
									<?php dynamic_sidebar( $id ); ?>
								</div>
								<?php
							}
						}
						?>
					</div>
				</div>
			</div>
		<?php } ?>
		<?php
	}
endif;
add_action( 'bizindustries_footer_widgets', 'bizindustries_footer_widgets', 10 );



if ( ! function_exists( 'bizindustries_footer_copyright' ) ) :
	/**
	 * Footer Copyright
	 *
	 * @since 1.0.0
	 */
	function bizindustries_footer_copyright() {
	?>
	<!-- Start Footer Bottom -->
	<div class="footer-bottom"> 
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<?php
					$copyright_text = get_theme_mod( 'footer_copyright_text');
					if ( $copyright_text ): ?>
						<p id="copyright-text"><?php echo esc_html( $copyright_text ); ?></p>
					<?php else: ?>
						<p id="copyright-text"><?php bloginfo(); ?> &copy; <?php echo esc_html( date_i18n( esc_html__( 'Y', 'bizindustries' ) ) ); ?>. <?php esc_html_e( 'All Rights Reserved.', 'bizindustries' ); ?></p>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
	<!-- End Footer Bottom -->
	<?php
	}
	
endif;
add_action( 'bizindustries_footer_copyright', 'bizindustries_footer_copyright', 10 );








