<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Bizindustries
 */

if ( ! function_exists( 'bizindustries_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function bizindustries_posted_on() {
		$time_string = '<time class="published"><strong>%1$s</strong><br /> %2$s</time>';
		if(is_single()){
			$time_string = '<time class="published"><strong>%1$s <br/>%2$s</strong> <br /><span class="p-date">%3$s</span></time>';
		}
		$time_string = sprintf(
			$time_string,
			esc_html( get_the_time('d') ),
			esc_html( get_the_time('M') ),
			esc_html( get_the_time('Y') )
		);

		$posted_on = sprintf(
			/* translators: %s: post date. */
			'%s',
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
		);

		echo '<span class="entry-date">' . $posted_on . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif;



if ( ! function_exists( 'bizindustries_posted_by' ) ) :
	/**
	 * Prints HTML with meta information for the current author.
	 */
	function bizindustries_posted_by() {
		$byline = sprintf(
			/* translators: %s: post author. */
			esc_html_x( 'by %s', 'post author', 'bizindustries' ),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);

		echo '<span class="byline"> ' . $byline . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif;


if ( ! function_exists( 'bizindustries_posted_in' ) ) :
	/**
	 * Prints HTML with meta information for the categories
	 */
	function bizindustries_posted_in() {

		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'bizindustries' ) );
			if ( $categories_list ) {
				/* translators: 1: list of categories. */
				printf( '<span class="cat-links"><i class="fa fa-pencil-square-o"></i> ' . '%1$s' . '</span>', $categories_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		}
	}
endif;


if ( ! function_exists( 'bizindustries_post_comments' ) ) :
	/**
	 * Prints HTML with meta information for the Comments
	 */
	function bizindustries_post_comments() {
		if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
			<span><i class="fa fa-commenting-o" aria-hidden="true"></i> <a href="<?php comments_link(); ?>"> <?php comments_number(); ?></a></span>
		<?php endif;
	}
endif;


if ( ! function_exists( 'bizindustries_post_thumbnail' ) ) :
	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function bizindustries_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
			?>

			<div class="entry-thumb">
				<?php the_post_thumbnail(); ?>
			</div><!-- .post-thumbnail -->

		<?php else : ?>

			<a class="entry-thumb" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
				<?php
					the_post_thumbnail(
						'post-thumbnail',
						array(
							'alt' => the_title_attribute(
								array(
									'echo' => false,
								)
							),
						)
					);
				?>
			</a>

			<?php
		endif; // End is_singular().
	}
endif;
