<?php 
	
if( ! function_exists( 'bizindustries_get_social_icons' ) ) :
	/**
	 * SVG for social icons
	*/
	function bizindustries_get_social_icons(){    

		$social_media = [ 'facebook', 'twitter', 'digg', 'instagram', 'pinterest', 'telegram', 'dribbble', 'behance', 'linkedin', 'WordPress', 'medium', 'slack', 'codepen', 'reddit', 'twitch', 'snapchat', 'spotify', 'soundcloud', 'apple_podcast', 'skype', 'github', 'gitlab', 'youtube', 'vimeo', 'vk', 'rss', 'tripadvisor', 'foursquare', 'yelp', 'xing', 'weibo', 'tumblr', 'qq', 'flickr' ];
		
		// Initate an empty array
		$svg_options = array();
		$svg_options[''] = __( ' -- Choose -- ', 'bizindustries' );
		
			foreach ( $social_media as $svg ) {			
				$svg_options[ $svg ] = esc_html( $svg );				
			}
		
		return $svg_options;
	}
endif;



if ( ! function_exists( 'bizindustries_social_icon_list' ) ) :    
/**
 * Get icons
*/
function bizindustries_social_icon_list( $social ){

if( !$social ){
        return;
    }
    switch ( $social ) {
        case 'facebook':
            return '<i class="fa fa-facebook" aria-hidden="true"></i>';
        break;

        case 'twitter':
            return '<i class="fa fa-twitter" aria-hidden="true"></i>';
        break;

        case 'instagram':
            return '<i class="fa fa-instagram" aria-hidden="true"></i>';
        break;

        case 'pinterest':
            return '<i class="fa fa-pinterest-p" aria-hidden="true"></i>';
        break;

        case 'digg':
            return '<i class="fa fa-digg" aria-hidden="true"></i>';
        break;

        case 'telegram':
            return '<i class="fa fa-telegram" aria-hidden="true"></i>';
        break;

        case 'dribbble':
            return '<i class="fa fa-dribbble" aria-hidden="true"></i>';
        break;

        case 'behance':
            return '<i class="fa fa-behance" aria-hidden="true"></i>';
        break;

        case 'linkedin':
            return '<i class="fa fa-linkedin" aria-hidden="true"></i>';
        break;

        case 'WordPress':
            return '<i class="fa fa-wordpress" aria-hidden="true"></i>';
        break;

        case 'medium':
            return '<i class="fa fa-medium" aria-hidden="true"></i>';
        break;

        case 'slack':
            return '<i class="fa fa-slack" aria-hidden="true"></i>';
        break;

        case 'codepen':
            return '<i class="fa fa-codepen" aria-hidden="true"></i>';
        break;

        case 'reddit':
            return '<i class="fa fa-reddit" aria-hidden="true"></i>';
        break;

        case 'twitch':
            return '<i class="fa fa-twitch" aria-hidden="true"></i>';
        break;

        case 'snapchat':
            return '<i class="fa fa-snapchat-ghost" aria-hidden="true"></i>';
        break;

        case 'spotify':
            return '<i class="fa fa-spotify" aria-hidden="true"></i>';
        break;

        case 'soundcloud':
            return '<i class="fa fa-soundcloud" aria-hidden="true"></i>';
        break;

        case 'apple_podcast':
            return '<i class="fa fa-podcast" aria-hidden="true"></i>';
        break;

        case 'skype':
            return '<i class="fa fa-skype" aria-hidden="true"></i>';
        break;

        case 'github':
            return '<i class="fa fa-github" aria-hidden="true"></i>';
        break;

        case 'gitlab':
            return '<i class="fa fa-gitlab" aria-hidden="true"></i';
        break;

        case 'youtube':
            return '<i class="fa fa-youtube" aria-hidden="true"></i>';
        break;

        case 'vimeo':
            return '<i class="fa fa-vimeo" aria-hidden="true"></i>';
        break;

        case 'vk':
            return '<i class="fa fa-vk" aria-hidden="true"></i>';
        break;

        case 'rss':
            return '<i class="fa fa-rss" aria-hidden="true"></i>';
        break;

        case 'tripadvisor':
            return '<i class="fa fa-tripadvisor" aria-hidden="true"></i>';
        break;

        case 'foursquare':
            return '<i class="fa fa-foursquare" aria-hidden="true"></i>';
        break;

        case 'yelp':
            return '<i class="fa fa-yelp" aria-hidden="true"></i>';
        break;

        case 'xing':
            return '<i class="fa fa-xing" aria-hidden="true"></i>';
        break;

        case 'whatsapp':
            return '<i class="fa fa-whatsapp" aria-hidden="true"></i>';
        break;

        case 'weibo':
            return '<i class="fa fa-weibo" aria-hidden="true"></i>';
        break;

        case 'tumblr':
            return '<i class="fa fa-tumblr" aria-hidden="true"></i>';
        break;

        case 'qq':
            return '<i class="fa fa-qq" aria-hidden="true"></i>';
        break;

        case 'flickr':
            return '<i class="fa fa-flickr" aria-hidden="true"></i>';
        break;

        case 'phone':
            return '<i class="fa fa-phone" aria-hidden="true"></i>';
        break;

        case 'clock':
            return '<i class="fa fa-clock-o" aria-hidden="true"></i>';
        break;

        case 'email':
            return '<i class="fa fa-envelope-o" aria-hidden="true"></i>';
        break;

        case 'location':
            return '<i class="fa fa-map-marker" aria-hidden="true"></i>';
        break;
        
        default:
            # code...
            break;
        }
}
endif;













