<?php 
	
	$wp_customize->add_section('bizindustries_product_single_settings', array(
		'title'    => __('Product Single', 'bizindustries'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	// Shop Layout settings
	$wp_customize->add_setting( 'product_single_layout',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => 'right-sidebar',
		)
	);
	$wp_customize->add_control( 'product_single_layout',
		array(
			'type'        => 'select',
			'label'       => esc_html__( 'Page Layout', 'bizindustries' ),
			'description' => '',
			'section'     => 'bizindustries_product_single_settings',
			'choices'     => array(
				'right-sidebar' => esc_html__( 'Right sidebar', 'bizindustries' ),
				'left-sidebar'  => esc_html__( 'Left sidebar', 'bizindustries' ),
				'no-sidebar'    => esc_html__( 'No sidebar', 'bizindustries' ),
			),
		)
	);
	
	$wp_customize->add_setting( 'product_single_related_enable', 
		array(
		  'default'  =>  true,
		  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'product_single_related_enable', 
		array(
		  'label'         => esc_html__( 'Show/hide Related products', 'bizindustries' ),
		  'description'   => esc_html__( 'Check/Uncheck this box to show/hide related products on single product page.', 'bizindustries' ),
		  'section'       => 'bizindustries_product_single_settings',
		  'type'          => 'checkbox',
		)
	);
	
	$wp_customize->add_setting( 'related_products_per_row',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => 3,
		)
	);
	$wp_customize->add_control( 'related_products_per_row',
		array(
			'type'        => 'select',
			'label'       => esc_html__( 'Related products per row', 'bizindustries' ),
			'description' => esc_html__( 'How many related products should be shown per row?', 'bizindustries' ),
			'section'     => 'bizindustries_product_single_settings',
			'choices'     => array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
			),
			'active_callback' => function(){
				 if(get_theme_mod('product_single_related_enable') == true){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	);